/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.buildcraft;

import buildcraft.api.mj.MjAPI;
import buildcraft.api.recipes.AssemblyRecipe;
import buildcraft.api.recipes.AssemblyRecipeBasic;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.lib.recipe.AssemblyRecipeRegistry;
import com.blamejared.mtlib.helpers.InputHelper;
import com.google.common.collect.ImmutableSet;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import moretweaker.Inputs;
import moretweaker.MoreTweaker;
import moretweaker.buildcraft.BuildUtil;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="moretweaker.buildcraft.AssemblyTable")
@ZenRegister
@ModOnly(value="buildcraftsilicon")
public class AssemblyTable {
    @ZenMethod
    public static void add(IItemStack output, long energyCost, IIngredient[] inputs) {
        ItemStack out = InputHelper.toStack((IItemStack)output);
        ImmutableSet<IngredientStack> in = BuildUtil.getIngredients(inputs);
        if (in.isEmpty()) {
            return;
        }
        final AssemblyRecipeBasic recipe = new AssemblyRecipeBasic(MoreTweaker.newRL(), energyCost * MjAPI.MJ, in, out);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                AssemblyRecipeRegistry.register((AssemblyRecipe)recipe);
            }

            public String describe() {
                return "Adds an AssemblyTable-Recipe";
            }
        });
    }

    @ZenMethod
    public static void remove(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                AssemblyRecipeRegistry.REGISTRY.values().removeIf(r -> Inputs.matchesForRemoval(out, r.getOutputPreviews()));
            }

            public String describe() {
                return "Removes AssemblyTable-Recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                AssemblyRecipeRegistry.REGISTRY.clear();
            }

            public String describe() {
                return "Removes all recipes for the Assembly Table";
            }
        });
    }
}

