/*
 * Decompiled with CFR 0.152.
 */
package moretweaker.betweenlands;

import com.blamejared.mtlib.helpers.InputHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import moretweaker.CraftingPart;
import moretweaker.Inputs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import thebetweenlands.api.IBetweenlandsAPI;
import thebetweenlands.api.recipes.IPurifierRecipe;
import thebetweenlands.common.BetweenlandsAPI;
import thebetweenlands.common.recipe.purifier.PurifierRecipeAspectVial;
import thebetweenlands.common.recipe.purifier.PurifierRecipeStandard;
import thebetweenlands.common.registries.ItemRegistry;

@ZenClass(value="moretweaker.betweenlands.Purifier")
@ZenRegister
@ModOnly(value="thebetweenlands")
public class Purifier {
    @ZenMethod
    public static void addRecipe(IIngredient input, IItemStack output) {
        final ItemStack out = InputHelper.toStack((IItemStack)output);
        final CraftingPart in = Inputs.getPart(input);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                for (ItemStack stack : in.toStackList()) {
                    BetweenlandsAPI.getInstance().registerPurifierRecipe((IPurifierRecipe)new PurifierRecipeStandard(out, stack));
                }
            }

            public String describe() {
                return "Adds some betweenlands Purifier recipes";
            }
        });
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        final Object out = Inputs.getObject(output);
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList recipes = new ArrayList();
                BetweenlandsAPI.getInstance().getPurifierRecipes().forEach(r -> {
                    if (PurifierRecipeStandard.class.isAssignableFrom(r.getClass()) && Inputs.matchesForRemoval(out, r.getOutput(Purifier.guessInput(r)))) {
                        recipes.add(r);
                    }
                });
                recipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterPurifierRecipe(arg_0));
            }

            public String describe() {
                return "Removes some betweenlands Purifier recipes";
            }
        });
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new IAction(){

            public void apply() {
                ArrayList allRecipes = new ArrayList(BetweenlandsAPI.getInstance().getPurifierRecipes());
                allRecipes.forEach(arg_0 -> ((IBetweenlandsAPI)BetweenlandsAPI.getInstance()).unregisterPurifierRecipe(arg_0));
            }

            public String describe() {
                return "Removes all recipes for the Purifier";
            }
        });
    }

    private static ItemStack guessInput(IPurifierRecipe recipe) {
        if (recipe instanceof PurifierRecipeStandard) {
            return recipe.getOutput(((PurifierRecipeStandard)recipe).getInput());
        }
        if (recipe instanceof PurifierRecipeAspectVial) {
            return new ItemStack((Item)ItemRegistry.DENTROTHYST_FLUID_VIAL);
        }
        return ItemStack.field_190927_a;
    }
}

