/*
 * Decompiled with CFR 0.152.
 */
package modulardiversity.components.requirements;

import hellfirepvp.modularmachinery.common.crafting.ComponentType;
import hellfirepvp.modularmachinery.common.crafting.helper.ComponentRequirement;
import hellfirepvp.modularmachinery.common.crafting.helper.RecipeCraftingContext;
import hellfirepvp.modularmachinery.common.machine.MachineComponent;
import hellfirepvp.modularmachinery.common.modifier.RecipeModifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import modulardiversity.components.requirements.RequirementEnvironmental;
import modulardiversity.jei.JEIComponentBiome;
import modulardiversity.jei.ingredients.BiomeIngredient;
import modulardiversity.util.IResourceToken;
import modulardiversity.util.Misc;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RequirementBiome
extends RequirementEnvironmental<BiomeIngredient, ResourceToken> {
    private HashSet<String> biomes;

    public RequirementBiome(MachineComponent.IOType actionType, String biome) {
        super(ComponentType.Registry.getComponent((String)"biome"), actionType);
        this.biomes = new HashSet();
        this.biomes.add(biome);
    }

    public RequirementBiome(MachineComponent.IOType actionType, Collection<String> biomes) {
        super(ComponentType.Registry.getComponent((String)"biome"), actionType);
        this.biomes = new HashSet<String>(biomes);
    }

    public RequirementBiome(MachineComponent.IOType actionType, String[] biomes) {
        super(ComponentType.Registry.getComponent((String)"biome"), actionType);
        this.biomes = new HashSet();
        for (String biome : biomes) {
            this.biomes.add(biome);
        }
    }

    public ComponentRequirement<BiomeIngredient> deepCopy() {
        return new RequirementBiome(this.getActionType(), this.biomes);
    }

    public ComponentRequirement<BiomeIngredient> deepCopyModified(List<RecipeModifier> modifiers) {
        return new RequirementBiome(this.getActionType(), this.biomes);
    }

    @Override
    protected String getInputProblem(ResourceToken token) {
        return "craftcheck.biome";
    }

    @Override
    protected String getOutputProblem(ResourceToken token) {
        return null;
    }

    @Override
    protected ResourceToken emitConsumptionToken(RecipeCraftingContext context) {
        return new ResourceToken();
    }

    @Override
    protected boolean consumeToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doConsume) {
        TileEntity tile = Misc.getTileEntity(component);
        if (tile != null && this.isValidBiome(tile.func_145831_w(), tile.func_174877_v())) {
            token.setRequirementMet();
            return true;
        }
        return false;
    }

    private boolean isValidBiome(World world, BlockPos pos) {
        return this.biomes.contains(world.func_180494_b(pos).getRegistryName().toString());
    }

    @Override
    protected boolean generateToken(MachineComponent component, RecipeCraftingContext context, ResourceToken token, boolean doGenerate) {
        return false;
    }

    public ComponentRequirement.JEIComponent<BiomeIngredient> provideJEIComponent() {
        return new JEIComponentBiome(this);
    }

    public Collection<String> getBiomes() {
        return this.biomes.stream().sorted().collect(Collectors.toList());
    }

    public static class ResourceToken
    implements IResourceToken {
        private boolean requirementMet;

        public void setRequirementMet() {
            this.requirementMet = true;
        }

        @Override
        public void applyModifiers(RecipeCraftingContext modifiers, MachineComponent.IOType ioType, float durationMultiplier) {
        }

        @Override
        public boolean isEmpty() {
            return this.requirementMet;
        }
    }
}

