/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.outputs;

import java.util.Random;
import mekanism.common.recipe.outputs.MachineOutput;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public class ChanceOutput
extends MachineOutput<ChanceOutput> {
    private static Random rand = new Random();
    public ItemStack primaryOutput = ItemStack.field_190927_a;
    public ItemStack secondaryOutput = ItemStack.field_190927_a;
    public double secondaryChance;

    public ChanceOutput(ItemStack primary, ItemStack secondary, double chance) {
        this.primaryOutput = primary;
        this.secondaryOutput = secondary;
        this.secondaryChance = chance;
    }

    public ChanceOutput() {
    }

    public ChanceOutput(ItemStack primary) {
        this.primaryOutput = primary;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.primaryOutput = new ItemStack(nbtTags.func_74775_l("primaryOutput"));
        this.secondaryOutput = new ItemStack(nbtTags.func_74775_l("secondaryOutput"));
        this.secondaryChance = nbtTags.func_74769_h("secondaryChance");
    }

    public boolean checkSecondary() {
        return rand.nextDouble() <= this.secondaryChance;
    }

    public boolean hasPrimary() {
        return !this.primaryOutput.func_190926_b();
    }

    public boolean hasSecondary() {
        return !this.secondaryOutput.func_190926_b();
    }

    public boolean applyOutputs(NonNullList<ItemStack> inventory, int primaryIndex, int secondaryIndex, boolean doEmit) {
        if (this.hasPrimary() && this.applyOutputs(inventory, primaryIndex, doEmit, this.primaryOutput)) {
            return false;
        }
        if (this.hasSecondary() && (!doEmit || this.checkSecondary())) {
            return !this.applyOutputs(inventory, secondaryIndex, doEmit, this.secondaryOutput);
        }
        return true;
    }

    private boolean applyOutputs(NonNullList<ItemStack> inventory, int index, boolean doEmit, ItemStack output) {
        ItemStack stack = (ItemStack)inventory.get(index);
        if (stack.func_190926_b()) {
            if (doEmit) {
                inventory.set(index, (Object)output.func_77946_l());
            }
            return false;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)output) && stack.func_190916_E() + output.func_190916_E() <= stack.func_77976_d()) {
            if (doEmit) {
                stack.func_190917_f(output.func_190916_E());
            }
            return false;
        }
        return true;
    }

    @Override
    public ChanceOutput copy() {
        return new ChanceOutput(this.primaryOutput.func_77946_l(), this.secondaryOutput.func_77946_l(), this.secondaryChance);
    }
}

