/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.inputs;

import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.common.recipe.inputs.MachineInput;
import net.minecraft.nbt.NBTTagCompound;

public class GasInput
extends MachineInput<GasInput> {
    public GasStack ingredient;

    public GasInput(GasStack stack) {
        this.ingredient = stack;
    }

    public GasInput() {
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.ingredient = GasStack.readFromNBT(nbtTags.func_74775_l("input"));
    }

    @Override
    public GasInput copy() {
        return new GasInput(this.ingredient.copy());
    }

    @Override
    public boolean isValid() {
        return this.ingredient != null;
    }

    public boolean useGas(GasTank gasTank, boolean deplete, int scale) {
        if (gasTank.getGasType() == this.ingredient.getGas() && gasTank.getStored() >= this.ingredient.amount * scale) {
            gasTank.draw(this.ingredient.amount * scale, deplete);
            return true;
        }
        return false;
    }

    @Override
    public int hashIngredients() {
        return this.ingredient.hashCode();
    }

    @Override
    public boolean testEquality(GasInput other) {
        if (!this.isValid()) {
            return !other.isValid();
        }
        return other.ingredient.hashCode() == this.ingredient.hashCode();
    }

    @Override
    public boolean isInstance(Object other) {
        return other instanceof GasInput;
    }
}

