/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.commands.client;

import com.gendeathrow.mputils.commands.client.MP_ItemDump;
import com.gendeathrow.mputils.utils.Tools;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public class MP_ModItemDump
extends MP_ItemDump {
    ArrayList<String> modnames = new ArrayList();
    int lastCheck = 0;

    public MP_ModItemDump() {
        this.modnames.clear();
        for (ModContainer modcontainer : Loader.instance().getModList()) {
            this.modnames.add(modcontainer.getModId());
        }
    }

    @Override
    public String getCommand() {
        return "moddump";
    }

    @Override
    public String getUsageSuffix() {
        return "modid " + super.getUsageSuffix();
    }

    public List<String> autoComplete(ICommandSender sender, String[] args) {
        if (args.length == 2) {
            return this.modnames;
        }
        if (args.length >= 2) {
            return this.options;
        }
        return new ArrayList<String>();
    }

    @Override
    public void runCommand(CommandBase command, MinecraftServer server, ICommandSender sender, String[] args) {
        if (sender != null && sender instanceof EntityPlayer && sender.func_130014_f_().field_72995_K) {
            String clipboard = "";
            String modid = args[1];
            EntityPlayer player = (EntityPlayer)sender;
            int total = Block.field_149771_c.func_148742_b().size() + Item.field_150901_e.func_148742_b().size();
            int cnt = 0;
            this.isSilent = true;
            for (Item item : Item.field_150901_e) {
                ItemStack stack;
                this.sendUpdate(sender, ++cnt, total);
                if (!((ResourceLocation)Item.field_150901_e.func_177774_c((Object)item)).func_110624_b().equals(modid.trim().toLowerCase()) || (stack = new ItemStack(item)).func_190926_b()) continue;
                NonNullList list = NonNullList.func_191196_a();
                item.func_150895_a(CreativeTabs.field_78027_g, list);
                if (list.size() > 0) {
                    for (ItemStack itemstack : list) {
                        clipboard = clipboard + this.parseStackData(sender, args, itemstack);
                    }
                    continue;
                }
                clipboard = clipboard + this.parseStackData(sender, args, stack);
            }
            this.isSilent = false;
            if (Tools.CopytoClipbard(clipboard)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(TextFormatting.YELLOW + " --Copied to Clipboard--", new Object[0]));
            }
        }
    }

    private void sendUpdate(ICommandSender sender, int cnt, int max) {
        int perc = (int)((float)cnt * 100.0f / (float)max);
        if (perc % 10 == 0 && perc != this.lastCheck) {
            this.lastCheck = perc;
            sender.func_145747_a((ITextComponent)new TextComponentString(perc + "%"));
        }
    }
}

