/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.api.container;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.IMultipart;
import mcmultipart.api.multipart.IMultipartTile;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.api.slot.ISlottedContainer;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public interface IMultipartContainer
extends ISlottedContainer<IPartInfo> {
    public World getPartWorld();

    public BlockPos getPartPos();

    @Override
    public Optional<IPartInfo> get(IPartSlot var1);

    default public Optional<IMultipart> getPart(IPartSlot slot) {
        return this.get(slot).map(IPartInfo::getPart);
    }

    default public Optional<IMultipartTile> getPartTile(IPartSlot slot) {
        return this.get(slot).map(IPartInfo::getTile);
    }

    default public Optional<IBlockState> getState(IPartSlot slot) {
        return this.get(slot).map(IPartInfo::getState);
    }

    public Map<IPartSlot, ? extends IPartInfo> getParts();

    default public boolean canAddPart(IPartSlot slot, IBlockState state) {
        IMultipart part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
        Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
        IMultipartTile tile = part.createMultipartTile(this.getPartWorld(), slot, state);
        return this.canAddPart(slot, state, tile);
    }

    public boolean canAddPart(IPartSlot var1, IBlockState var2, IMultipartTile var3);

    default public void addPart(IPartSlot slot, IBlockState state) {
        IMultipart part = MultipartRegistry.INSTANCE.getPart(state.func_177230_c());
        Preconditions.checkState((part != null ? 1 : 0) != 0, (Object)("The blockstate " + state + " could not be converted to a multipart!"));
        IMultipartTile tile = part.createMultipartTile(this.getPartWorld(), slot, state);
        this.addPart(slot, state, tile);
    }

    public void addPart(IPartSlot var1, IBlockState var2, IMultipartTile var3);

    public void removePart(IPartSlot var1);

    default public void notifyChange(IPartInfo part) {
        for (IPartInfo iPartInfo : this.getParts().values()) {
            if (iPartInfo == part) continue;
            iPartInfo.getPart().onPartChanged(iPartInfo, part);
        }
    }
}

