/*
 * Decompiled with CFR 0.152.
 */
package com.github.terminatornl.laggoggles.client;

import com.github.terminatornl.laggoggles.api.event.LagGogglesEvent;
import com.github.terminatornl.laggoggles.client.ClientConfig;
import com.github.terminatornl.laggoggles.client.gui.GuiProfile;
import com.github.terminatornl.laggoggles.client.gui.LagOverlayGui;
import com.github.terminatornl.laggoggles.packet.ObjectData;
import com.github.terminatornl.laggoggles.packet.SPacketScanResult;
import com.github.terminatornl.laggoggles.profiler.ProfileManager;
import com.github.terminatornl.laggoggles.profiler.ProfileResult;
import com.github.terminatornl.laggoggles.util.Calculations;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ScanResultHandler
implements IMessageHandler<SPacketScanResult, IMessage> {
    private ArrayList<ObjectData> builder = new ArrayList();

    public IMessage onMessage(SPacketScanResult message, MessageContext ctx) {
        long tickCount = message.tickCount > 0L ? message.tickCount : 1L;
        for (ObjectData objectData : message.DATA) {
            if (!(Calculations.muPerTickCustomTotals((Long)objectData.getValue(ObjectData.Entry.NANOS), tickCount) >= (double)ClientConfig.MINIMUM_AMOUNT_OF_MICROSECONDS_THRESHOLD)) continue;
            this.builder.add(objectData);
        }
        if (!message.hasMore) {
            ProfileResult result = new ProfileResult(message.startTime, message.endTime, tickCount, message.side, message.type);
            result.addAll(this.builder);
            result.lock();
            this.builder = new ArrayList();
            ProfileManager.LAST_PROFILE_RESULT.set(result);
            LagOverlayGui.create(result);
            LagOverlayGui.show();
            GuiProfile.update();
            MinecraftForge.EVENT_BUS.post((Event)new LagGogglesEvent.ReceivedFromServer(result));
        }
        return null;
    }
}

