/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IItemNetwork;
import org.cyclops.integratedtunnels.capability.network.ItemNetworkConfig;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceItem
extends PartTypeInterfacePositionedAddon<IItemNetwork, IItemHandler, PartTypeInterfaceItem, State> {
    public PartTypeInterfaceItem(String name) {
        super(name);
    }

    @Override
    protected Capability<IItemNetwork> getNetworkCapability() {
        return ItemNetworkConfig.CAPABILITY;
    }

    @Override
    protected Capability<IItemHandler> getTargetCapability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceItemBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<PartTypeInterfaceItem, IItemNetwork, IItemHandler>
    implements IItemHandler,
    ISlotlessItemHandler {
        @Override
        protected Capability<IItemHandler> getTargetCapability() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        protected IItemHandler getItemHandler() {
            return (IItemHandler)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getChannel());
        }

        public int getSlots() {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getItemHandler().getSlots();
            this.enablePosition();
            return ret;
        }

        public ItemStack getStackInSlot(int slot) {
            if (!this.isNetworkAndPositionValid()) {
                return ItemStack.field_190927_a;
            }
            this.disablePosition();
            ItemStack ret = this.getItemHandler().getStackInSlot(slot);
            this.enablePosition();
            return ret;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return stack;
            }
            this.disablePosition();
            ItemStack ret = this.getItemHandler().insertItem(slot, stack, simulate);
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return ItemStack.field_190927_a;
            }
            this.disablePosition();
            ItemStack ret = this.getItemHandler().extractItem(slot, amount, simulate);
            this.enablePosition();
            return ret;
        }

        public int getSlotLimit(int slot) {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int ret = this.getItemHandler().getSlotLimit(slot);
            this.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> getItems() {
            if (!this.isNetworkAndPositionValid()) {
                return Iterators.forArray((Object[])new ItemStack[0]);
            }
            this.disablePosition();
            Iterator ret = ((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).iterator();
            this.enablePosition();
            return ret;
        }

        public Iterator<ItemStack> findItems(@Nonnull ItemStack stack, int matchFlags) {
            if (!this.isNetworkAndPositionValid()) {
                return Iterators.forArray((Object[])new ItemStack[0]);
            }
            this.disablePosition();
            Iterator ret = ((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).iterator((Object)stack, (Object)matchFlags);
            this.enablePosition();
            return ret;
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return stack;
            }
            this.disablePosition();
            ItemStack ret = (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).insert((Object)stack, simulate);
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(int amount, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return ItemStack.field_190927_a;
            }
            this.disablePosition();
            ItemStack ret = (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).extract((long)amount, simulate);
            this.enablePosition();
            return ret;
        }

        public ItemStack extractItem(ItemStack matchStack, int matchFlags, boolean simulate) {
            if (!this.isNetworkAndPositionValid()) {
                return ItemStack.field_190927_a;
            }
            this.disablePosition();
            ItemStack ret = (ItemStack)((IItemNetwork)this.getPositionedAddonsNetwork()).getChannel(this.getChannelInterface()).extract((Object)matchStack, (Object)matchFlags, simulate);
            this.enablePosition();
            return ret;
        }

        public int getLimit() {
            if (!this.isNetworkAndPositionValid()) {
                return 0;
            }
            this.disablePosition();
            int limit = 0;
            IItemHandler itemHandler = this.getItemHandler();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                limit += itemHandler.getSlotLimit(i);
            }
            this.enablePosition();
            return limit;
        }

        public boolean hasCapability(Capability<?> capability) {
            return this.isNetworkAndPositionValid() && capability == Capabilities.SLOTLESS_ITEMHANDLER || super.hasCapability(capability);
        }

        public <T> T getCapability(Capability<T> capability) {
            if (this.isNetworkAndPositionValid() && capability == Capabilities.SLOTLESS_ITEMHANDLER) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability);
        }
    }
}

