/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.tileentity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.event.INetworkEvent;
import org.cyclops.integrateddynamics.capability.valueinterface.ValueInterfaceConfig;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.event.VariableContentsUpdatedEvent;
import org.cyclops.integrateddynamics.core.tileentity.TileCableConnectableInventory;

public abstract class TileActiveVariableBase<E>
extends TileCableConnectableInventory
implements IDirtyMarkListener,
INetworkEventListener<E> {
    private final InventoryVariableEvaluator<IValue> evaluator;

    public TileActiveVariableBase(int inventorySize, String inventoryName) {
        super(inventorySize, inventoryName, 1);
        this.inventory.addDirtyMarkListener((IDirtyMarkListener)this);
        this.addCapabilityInternal(ValueInterfaceConfig.CAPABILITY, () -> {
            IVariable<?> variable;
            INetwork network = this.getNetwork();
            IPartNetwork partNetwork = NetworkHelpers.getPartNetwork(network);
            if (network == null || partNetwork == null) {
                throw new EvaluationException("No valid network was found");
            }
            if (this.hasVariable() && (variable = this.getVariable(partNetwork)) != null) {
                return Optional.of(variable.getValue());
            }
            return Optional.empty();
        });
        this.evaluator = this.createEvaluator();
    }

    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((IInventory)this, this.getSlotRead(), ValueTypes.CATEGORY_ANY);
    }

    public InventoryVariableEvaluator getEvaluator() {
        return this.evaluator;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        List<L10NHelpers.UnlocalizedString> errors = this.evaluator.getErrors();
        NBTClassType.writeNbt(List.class, (String)"errors", errors, (NBTTagCompound)tag);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.evaluator.setErrors((List)NBTClassType.readNbt(List.class, (String)"errors", (NBTTagCompound)tag));
        super.func_145839_a(tag);
    }

    public abstract int getSlotRead();

    public boolean hasVariable() {
        return !this.func_70301_a(this.getSlotRead()).func_190926_b();
    }

    protected void updateReadVariable(boolean sendVariablesUpdateEvent) {
        this.evaluator.refreshVariable(this.getNetwork(), sendVariablesUpdateEvent);
        this.sendUpdate();
    }

    public void onDirty() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateReadVariable(true);
        }
    }

    @Nullable
    public IVariable<?> getVariable(IPartNetwork network) {
        return this.evaluator.getVariable(network);
    }

    @Override
    public boolean hasEventSubscriptions() {
        return true;
    }

    @Override
    public Set<Class<? extends INetworkEvent>> getSubscribedEvents() {
        return Sets.newHashSet((Object[])new Class[]{VariableContentsUpdatedEvent.class});
    }

    @Override
    public void onEvent(INetworkEvent event, E networkElement) {
        if (event instanceof VariableContentsUpdatedEvent) {
            this.updateReadVariable(false);
        }
    }

    @Override
    public void afterNetworkReAlive() {
        super.afterNetworkReAlive();
        this.updateReadVariable(true);
    }
}

