/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.particle.api;

import com.zeitheron.hammercore.client.particle.FXGroupRenderer;
import com.zeitheron.hammercore.client.particle.ParticleGrouped;
import com.zeitheron.hammercore.client.particle.api.IParticleGetter;
import com.zeitheron.hammercore.client.particle.api.IRenderedParticle;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class ParticleList {
    private static final Set<IParticleGetter> getters = new HashSet<IParticleGetter>();
    private static final Set<Particle> vanillaParticleSet = new HashSet<Particle>();
    private static final List<Particle> vanillaParticleList = new ArrayList<Particle>();
    private static final List<IRenderedParticle> renderedParticleList = new ArrayList<IRenderedParticle>();
    private static final List<ParticleGrouped> groupedParticleList = new ArrayList<ParticleGrouped>();

    public static void addGetter(IParticleGetter getter) {
        getters.add(getter);
    }

    public static List<Particle> getParticlesWithinAABB(AxisAlignedBB bounds) {
        ArrayList<Particle> particles = new ArrayList<Particle>();
        List<Particle> ps = ParticleList.getParticlesList();
        for (int i = 0; i < ps.size(); ++i) {
            Particle p = ps.get(i);
            AxisAlignedBB pbb = p.func_187116_l();
            if (pbb == null || !pbb.func_72326_a(bounds)) continue;
            particles.add(p);
        }
        return particles;
    }

    public static void refreshParticles() {
        vanillaParticleSet.clear();
        vanillaParticleList.clear();
        renderedParticleList.clear();
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        for (IParticleGetter getter : getters) {
            getter.addParticles(vanillaParticleSet);
        }
        vanillaParticleList.addAll(vanillaParticleSet);
        for (int i = 0; i < vanillaParticleList.size(); ++i) {
            Particle p = vanillaParticleList.get(i);
            if (!(p instanceof IRenderedParticle)) continue;
            renderedParticleList.add((IRenderedParticle)p);
        }
    }

    public static void renderExtendedParticles(RenderWorldLastEvent evt) {
        EntityPlayerSP entityIn = Minecraft.func_71410_x().field_71439_g;
        ActiveRenderInfo.func_74583_a((EntityPlayer)entityIn, (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2 ? 1 : 0) != 0);
        FXGroupRenderer.INSTANCE.render(evt);
        for (int i = 0; i < renderedParticleList.size(); ++i) {
            Particle p = (Particle)renderedParticleList.get(i);
            IRenderedParticle rp = renderedParticleList.get(i);
            if (rp == null || !rp.isRendered()) continue;
            rp.setRendered();
            float rotationX = ActiveRenderInfo.func_178808_b();
            float rotationZ = ActiveRenderInfo.func_178809_c();
            float rotationYZ = ActiveRenderInfo.func_178803_d();
            float rotationXY = ActiveRenderInfo.func_178805_e();
            float rotationXZ = ActiveRenderInfo.func_178807_f();
            float partialTicks = evt.getPartialTicks();
            Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
            Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
            Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
            Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179092_a((int)516, (float)0.003921569f);
            rp.doRenderParticle(p.field_187126_f - TileEntityRendererDispatcher.field_147554_b, p.field_187127_g - TileEntityRendererDispatcher.field_147555_c, p.field_187128_h - TileEntityRendererDispatcher.field_147552_d, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
    }

    public static Set<Particle> getParticlesSet() {
        return vanillaParticleSet;
    }

    public static List<Particle> getParticlesList() {
        return vanillaParticleList;
    }

    public static List<IRenderedParticle> getRenderedParticleList() {
        return renderedParticleList;
    }

    static {
        ParticleList.addGetter(new DefaultParticleGetter());
    }

    private static class DefaultParticleGetter
    implements IParticleGetter {
        private DefaultParticleGetter() {
        }

        @Override
        public void addParticles(Set<Particle> particlesSet) {
            try {
                ArrayDeque[][] particles;
                ArrayDeque[][] arrayDequeArray = particles = Minecraft.func_71410_x().field_71452_i.field_78876_b;
                int n = arrayDequeArray.length;
                for (int i = 0; i < n; ++i) {
                    ArrayDeque[] layer;
                    for (ArrayDeque deque : layer = arrayDequeArray[i]) {
                        for (Particle p : deque) {
                            if (p instanceof ParticleGrouped) {
                                FXGroupRenderer.INSTANCE.addParticle((ParticleGrouped)p);
                                deque.remove(p);
                                continue;
                            }
                            particlesSet.add(p);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

