/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.compat.jei.endercrafter;

import com.blakebr0.cucumber.helper.ResourceHelper;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.compat.jei.tablecrafting.TableShapelessWrapper;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EnderCrafterCategory
implements IRecipeCategory<IRecipeWrapper> {
    public static final String UID = "extendedcrafting:ender_crafting";
    private static final ResourceLocation TEXTURE = ResourceHelper.getResource((String)"extendedcrafting", (String)"textures/jei/ender_crafting.png");
    private final IDrawable background;
    private final IDrawableAnimated arrow;

    public EnderCrafterCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 116, 54);
        IDrawableStatic arrowDrawable = helper.createDrawable(TEXTURE, 195, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return Utils.localize((String)"jei.ec.ender_crafting");
    }

    public String getModName() {
        return "Extended Crafting: Nomifactory Edition";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 61, 19);
    }

    public void setRecipe(IRecipeLayout layout, IRecipeWrapper wrapper, IIngredients ingredients) {
        IGuiItemStackGroup stacks = layout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0);
        stacks.init(0, false, 94, 18);
        stacks.set(0, outputs);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int index = 1 + j + i * 3;
                stacks.init(index, true, j * 18, i * 18);
            }
        }
        int xd = 1;
        for (List stack : inputs) {
            stacks.set(xd, stack);
            ++xd;
        }
        if (wrapper instanceof TableShapelessWrapper) {
            layout.setShapeless();
        }
        layout.setRecipeTransferButton(122, 41);
    }
}

