/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.block.craftingtable;

import com.blakebr0.cucumber.block.BlockBase;
import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.cucumber.util.Utils;
import com.blakebr0.extendedcrafting.ExtendedCrafting;
import com.blakebr0.extendedcrafting.config.ModConfig;
import com.blakebr0.extendedcrafting.tile.AbstractExtendedTable;
import com.blakebr0.extendedcrafting.tile.TileAdvancedCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileBasicCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileEliteCraftingTable;
import com.blakebr0.extendedcrafting.tile.TileUltimateCraftingTable;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class AbstractTableBlock
extends BlockBase
implements ITileEntityProvider,
IEnableable {
    private final TableTier tier;

    public AbstractTableBlock(TableTier tier) {
        super("ec.table_" + tier.name().toLowerCase(), Material.field_151573_f, SoundType.field_185852_e, 5.0f, 10.0f);
        this.tier = tier;
        this.func_149647_a(ExtendedCrafting.CREATIVE_TAB);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        if (!world.field_72995_K && (tileentity = world.func_175625_s(pos)) instanceof AbstractExtendedTable) {
            player.openGui((Object)ExtendedCrafting.instance, 7 + this.tier.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Nullable
    protected AbstractExtendedTable getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractExtendedTable) {
            return (AbstractExtendedTable)tile;
        }
        return null;
    }

    @Nullable
    public AbstractExtendedTable createNewTileEntity(World worldIn, int meta) {
        return this.tier.constructor.get();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        AbstractExtendedTable tile = this.getTile(world, pos);
        if (tile != null) {
            NonNullList<ItemStack> matrix = tile.getMatrix();
            for (ItemStack stack : matrix) {
                AbstractTableBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return facing == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isEnabled() {
        return ModConfig.confTableEnabled;
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(Utils.localize((String)"tooltip.ec.tier", (Object[])new Object[]{this.tier.ordinal() + 1}));
    }

    protected static enum TableTier {
        BASIC(TileBasicCraftingTable::new),
        ADVANCED(TileAdvancedCraftingTable::new),
        ELITE(TileEliteCraftingTable::new),
        ULTIMATE(TileUltimateCraftingTable::new);

        public final Supplier<? extends AbstractExtendedTable> constructor;

        private TableTier(Supplier<? extends AbstractExtendedTable> constructor) {
            this.constructor = constructor;
        }
    }
}

