/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraftcompat.modcompat.bloodmagic;

import WayofTime.bloodmagic.core.data.SoulNetwork;
import WayofTime.bloodmagic.util.helper.NetworkHelper;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.WorldHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.BoundBloodDropConfig;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.RequestSoulNetworkUpdatesPacket;
import org.cyclops.evilcraftcompat.modcompat.bloodmagic.UpdateSoulNetworkCachePacket;

public class ClientSoulNetworkHandler {
    private static ClientSoulNetworkHandler _instance = null;
    private Map<String, Integer> PLAYER_CONTENTS_CACHE = Maps.newHashMap();
    private Map<String, Integer> PLAYER_MAX_CACHE = Maps.newHashMap();
    private Set<String> UPDATE_PLAYERS = Sets.newHashSet();

    private ClientSoulNetworkHandler() {
    }

    public static void reset() {
        ClientSoulNetworkHandler.getInstance().PLAYER_CONTENTS_CACHE = Maps.newHashMap();
        ClientSoulNetworkHandler.getInstance().PLAYER_MAX_CACHE = Maps.newHashMap();
    }

    public static ClientSoulNetworkHandler getInstance() {
        if (_instance == null) {
            _instance = new ClientSoulNetworkHandler();
        }
        return _instance;
    }

    public int getCurrentEssence(UUID uuid) {
        if (MinecraftHelpers.isClientSide()) {
            Integer ret = this.PLAYER_CONTENTS_CACHE.get(uuid.toString());
            if (ret == null) {
                EvilCraft._instance.getPacketHandler().sendToServer((PacketBase)new RequestSoulNetworkUpdatesPacket(uuid.toString()));
                return 0;
            }
            return ret;
        }
        return NetworkHelper.getSoulNetwork((UUID)uuid).getCurrentEssence();
    }

    public void setCurrentEssence(String uuid, int currentEssence) {
        this.PLAYER_CONTENTS_CACHE.put(uuid, currentEssence);
    }

    public int getMaxEssence(UUID uuid) {
        if (MinecraftHelpers.isClientSide()) {
            Integer ret = this.PLAYER_MAX_CACHE.get(uuid.toString());
            if (ret == null) {
                EvilCraft._instance.getPacketHandler().sendToServer((PacketBase)new RequestSoulNetworkUpdatesPacket(uuid.toString()));
                return 0;
            }
            return ret;
        }
        return NetworkHelper.getMaximumForTier((int)NetworkHelper.getSoulNetwork((UUID)uuid).getOrbTier());
    }

    public void setMaxEssence(String uuid, int currentEssence) {
        this.PLAYER_MAX_CACHE.put(uuid, currentEssence);
    }

    public void addUpdatePlayer(EntityPlayerMP player, String uuid) {
        this.UPDATE_PLAYERS.add(uuid);
        EvilCraft._instance.getPacketHandler().sendToPlayer((PacketBase)new UpdateSoulNetworkCachePacket(this.PLAYER_CONTENTS_CACHE, this.PLAYER_MAX_CACHE), player);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && WorldHelpers.efficientTick((World)FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0], (int)BoundBloodDropConfig.maxUpdateTicks, (int[])new int[0])) {
            HashMap toSend = Maps.newHashMap();
            HashMap toSendMax = Maps.newHashMap();
            for (String uuid : this.UPDATE_PLAYERS) {
                Integer foundMax;
                SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork((String)uuid);
                int essence = soulNetwork.getCurrentEssence();
                int max = NetworkHelper.getMaximumForTier((int)soulNetwork.getOrbTier());
                Integer found = this.PLAYER_CONTENTS_CACHE.get(uuid);
                if (found == null || essence != found) {
                    toSend.put(uuid, essence);
                    this.setCurrentEssence(uuid, essence);
                }
                if ((foundMax = this.PLAYER_MAX_CACHE.get(uuid)) != null && max == foundMax) continue;
                toSendMax.put(uuid, max);
                this.setMaxEssence(uuid, max);
            }
            this.sendUpdates(toSend, toSendMax);
        }
    }

    private void sendUpdates(Map<String, Integer> toSendContents, Map<String, Integer> toSendMax) {
        if (!toSendContents.isEmpty() || !toSendMax.isEmpty()) {
            EvilCraft._instance.getPacketHandler().sendToAll((PacketBase)new UpdateSoulNetworkCachePacket(toSendContents, toSendMax));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            ClientSoulNetworkHandler.reset();
        }
    }
}

