/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.block;

import java.util.Random;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.evilcraft.EvilCraft;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.item.EnvironmentalAccumulationCoreConfig;
import org.cyclops.evilcraft.tileentity.TileEnvironmentalAccumulator;
import org.cyclops.evilcraft.world.gen.DarkTempleGenerator;

public class EnvironmentalAccumulator
extends ConfigurableBlockContainer
implements IMachine<EnvironmentalAccumulator, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> {
    private static EnvironmentalAccumulator _instance = null;
    public static final int STATE_IDLE = 0;
    public static final int STATE_PROCESSING_ITEM = 1;
    public static final int STATE_COOLING_DOWN = 2;
    public static final int STATE_FINISHED_PROCESSING_ITEM = 3;

    public static EnvironmentalAccumulator getInstance() {
        return _instance;
    }

    public EnvironmentalAccumulator(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileEnvironmentalAccumulator.class);
        this.setRotatable(true);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(50.0f);
        this.func_149752_b(6000000.0f);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean func_149721_r(IBlockState blockState) {
        return false;
    }

    protected void onPreBlockDestroyed(World world, BlockPos blockPos) {
        BlockPos closest;
        if (!world.field_72995_K && (closest = DarkTempleGenerator.getClosestForCoords(world, blockPos.func_177958_n(), blockPos.func_177952_p())) != null) {
            EvilCraft.darkTempleData.addFailedLocation(world.field_73011_w.getDimension(), closest.func_177958_n() / 16, closest.func_177952_p() / 16);
        }
        super.onPreBlockDestroyed(world, blockPos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return EnvironmentalAccumulationCoreConfig._instance.getItemInstance();
    }

    public IRecipeRegistry<EnvironmentalAccumulator, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeComponent, EnvironmentalAccumulatorRecipeProperties> getRecipeRegistry() {
        return ((ISuperRecipeRegistry)EvilCraft._instance.getRegistryManager().getRegistry(ISuperRecipeRegistry.class)).getRecipeRegistry((IMachine)this);
    }
}

