/*
 * Decompiled with CFR 0.152.
 */
package erebus.recipes;

import erebus.core.helper.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OfferingAltarRecipe {
    private static final List<OfferingAltarRecipe> list = new ArrayList<OfferingAltarRecipe>();
    private final ItemStack output;
    private final Object[] inputs;

    public static List<OfferingAltarRecipe> getRecipeList() {
        return Collections.unmodifiableList(list);
    }

    public static void addRecipe(ItemStack output, Object ... inputs) {
        list.add(new OfferingAltarRecipe(output, inputs));
    }

    public static ItemStack getOutput(ItemStack input1, ItemStack input2, ItemStack input3) {
        for (OfferingAltarRecipe recipe : list) {
            if (!recipe.matches(input1, input2, input3)) continue;
            return recipe.getOutput();
        }
        return ItemStack.field_190927_a;
    }

    private OfferingAltarRecipe(ItemStack output, Object ... inputs) {
        this.output = output;
        this.inputs = inputs;
        if (inputs.length > 3) {
            throw new IllegalArgumentException("Must not have more than 3 inputs.");
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] == null) {
                throw new IllegalArgumentException("Input must not be null.");
            }
            boolean isStack = inputs[i] instanceof ItemStack;
            boolean isString = inputs[i] instanceof String;
            if (isString) {
                inputs[i] = OreDictionary.getOres((String)((String)inputs[i]));
                continue;
            }
            if (isStack) continue;
            throw new IllegalArgumentException("Input must not be an ItemStack or a String.");
        }
    }

    public boolean matches(ItemStack input1, ItemStack input2, ItemStack input3) {
        ItemStack[] stacks = new ItemStack[]{input1, input2, input3};
        block0: for (Object input : this.inputs) {
            for (int i = 0; i < stacks.length; ++i) {
                if (stacks[i].func_190926_b()) continue;
                if (input instanceof ItemStack) {
                    if (!Utils.areStacksTheSame((ItemStack)input, stacks[i], false)) continue;
                    stacks[i] = ItemStack.field_190927_a;
                    continue block0;
                }
                for (ItemStack s : (NonNullList)input) {
                    if (!Utils.areStacksTheSame(s, stacks[i], false)) continue;
                    stacks[i] = ItemStack.field_190927_a;
                    continue block0;
                }
            }
            return false;
        }
        return true;
    }

    public boolean isPartOfInput(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (Object input : this.inputs) {
            if (input instanceof ItemStack) {
                if (!Utils.areStacksTheSame((ItemStack)input, stack, false)) continue;
                return true;
            }
            for (ItemStack s : (ArrayList)input) {
                if (!Utils.areStacksTheSame(s, stack, false)) continue;
                return true;
            }
        }
        return false;
    }

    public Object[] getInputs() {
        return this.inputs;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }
}

