/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.Erebus;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.teleporter.TeleporterHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ErebusPortal
extends Block {
    public ErebusPortal() {
        super(Material.field_151567_E);
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.func_149672_a(SoundType.field_185853_f);
    }

    public static boolean obeysPortalRule(World world, int x, int y, int z, boolean actualPortal) {
        int neighborPortals = 0;
        int axisFlag = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int opZ;
            int opY;
            int atZ;
            int atY;
            int atX = x + dir.func_82601_c();
            Block at = world.func_180495_p(new BlockPos(atX, atY = y + dir.func_96559_d(), atZ = z + dir.func_82599_e())).func_177230_c();
            if (!ErebusPortal.isSubstrate(at, actualPortal)) continue;
            int opX = x - dir.func_82601_c();
            IBlockState op = world.func_180495_p(new BlockPos(opX, opY = y - dir.func_96559_d(), opZ = z - dir.func_82599_e()));
            if (!op.func_185915_l() && !ErebusPortal.isSubstrate(op.func_177230_c(), actualPortal)) {
                return false;
            }
            ++neighborPortals;
            axisFlag |= 1 << (dir.ordinal() >> 1);
        }
        if (neighborPortals < 1) {
            return false;
        }
        return axisFlag != 7;
    }

    private static boolean isSubstrate(Block block, boolean portalNotLeaf) {
        return portalNotLeaf ? block instanceof ErebusPortal : block instanceof BlockLeaves;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!ErebusPortal.obeysPortalRule(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), true)) {
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (!entityIn.func_184218_aH() && !entityIn.func_184207_aI() && entityIn.field_71088_bW <= 0) {
            if (entityIn.field_71093_bK == 0) {
                TeleporterHandler.transferToErebus(entityIn);
            } else {
                TeleporterHandler.transferToOverworld(entityIn);
            }
            if (entityIn != null) {
                entityIn.field_71088_bW = ConfigHandler.INSTANCE.portalCooldown * 20;
            }
            return;
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        if (state != iblockstate) {
            return true;
        }
        if (block == this) {
            return false;
        }
        return block == this ? false : super.func_176225_a(state, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        for (int amount = 0; amount < 4; ++amount) {
            double x = (float)pos.func_177958_n() + rand.nextFloat();
            double y = (float)pos.func_177956_o() + rand.nextFloat();
            double z = (float)pos.func_177952_p() + rand.nextFloat();
            double velX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double velY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double velZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            int offSet = rand.nextInt(2) * 2 - 1;
            if (world.func_180495_p(pos.func_177976_e()).func_177230_c() != this && world.func_180495_p(pos.func_177974_f()).func_177230_c() != this) {
                x = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)offSet;
                velX = rand.nextFloat() * 2.0f * (float)offSet;
            } else {
                z = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)offSet;
                velZ = rand.nextFloat() * 2.0f * (float)offSet;
            }
            Erebus.PROXY.spawnCustomParticle("erebus_portal", world, x, y, z, velX, velY, velZ);
        }
    }
}

