/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

public class GasUtil {
    public static boolean areGasesTheSame(@Nullable Gas gas, @Nullable Gas gas2) {
        if (gas == null) {
            return gas2 == null;
        }
        if (gas2 == null) {
            return false;
        }
        return gas == gas2 || gas.getName().equals(gas2.getName());
    }

    public static GasStack getGasTypeFromItem(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (stack.func_77973_b() instanceof IGasItem) {
            return ((IGasItem)stack.func_77973_b()).getGas(stack);
        }
        return null;
    }

    public static GasStack getGasStack(IGasHandler handler, EnumFacing side) {
        if (handler == null) {
            return null;
        }
        GasTankInfo[] tankInfo = handler.getTankInfo();
        int stored = 0;
        Gas type = null;
        for (GasTankInfo info : tankInfo) {
            GasStack gasStack = info.getGas();
            if (gasStack == null || type != null && !GasUtil.areGasesTheSame(type, gasStack.getGas()) || !handler.canDrawGas(side, gasStack.getGas())) continue;
            stored += info.getStored();
            type = gasStack.getGas();
        }
        if (type == null || stored <= 0) {
            return null;
        }
        return new GasStack(type, stored);
    }
}

