/*
 * Decompiled with CFR 0.152.
 */
package gg.galaxygaming.gasconduits.common.conduit.basic;

import com.enderio.core.common.util.Log;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.conduits.render.ConduitTexture;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduit;
import gg.galaxygaming.gasconduits.common.conduit.AbstractGasTankConduitNetwork;
import gg.galaxygaming.gasconduits.common.conduit.GasConduitObject;
import gg.galaxygaming.gasconduits.common.conduit.IGasConduit;
import gg.galaxygaming.gasconduits.common.conduit.basic.GasConduitNetwork;
import gg.galaxygaming.gasconduits.common.config.GasConduitConfig;
import gg.galaxygaming.gasconduits.common.network.PacketConduitGasLevel;
import gg.galaxygaming.gasconduits.common.utils.GasUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GasConduit
extends AbstractGasTankConduit {
    static final int VOLUME_PER_CONNECTION = 250;
    public static final IConduitTexture ICON_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit", (boolean)false), ConduitTexture.arm((int)0));
    public static final IConduitTexture ICON_KEY_LOCKED = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_locked", (boolean)false));
    public static final IConduitTexture ICON_CORE_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_core", (boolean)false), ConduitTexture.core((int)0));
    public static final IConduitTexture ICON_EXTRACT_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_extract", (boolean)false));
    public static final IConduitTexture ICON_EMPTY_EXTRACT_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/empty_gas_conduit_extract", (boolean)false));
    public static final IConduitTexture ICON_INSERT_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/gas_conduit_insert", (boolean)false));
    public static final IConduitTexture ICON_EMPTY_INSERT_KEY = new ConduitTexture(TextureRegistry.registerTexture((String)"gasconduits:blocks/empty_gas_conduit_insert", (boolean)false));
    private GasConduitNetwork network;
    private float lastSyncRatio = -99.0f;
    private int currentPushToken;
    private EnumFacing startPushDir = EnumFacing.DOWN;
    private long ticksSinceFailedExtract = 0L;

    public void updateEntity(@Nonnull World world) {
        super.updateEntity(world);
        if (world.field_72995_K) {
            return;
        }
        this.updateStartPushDir();
        this.doExtract();
        if (this.stateDirty) {
            this.getBundle().dirty();
            this.stateDirty = false;
            this.lastSyncRatio = this.tank.getFilledRatio();
        } else if (this.lastSyncRatio != this.tank.getFilledRatio() && world.func_82737_E() % 2L == 0L) {
            BlockPos pos = this.getBundle().getLocation();
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketConduitGasLevel(this), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
            this.lastSyncRatio = this.tank.getFilledRatio();
        }
    }

    private void doExtract() {
        if (!this.hasExtractableMode()) {
            return;
        }
        ++this.ticksSinceFailedExtract;
        if (this.ticksSinceFailedExtract > 9L && this.ticksSinceFailedExtract % 10L != 0L) {
            return;
        }
        int tier1ExtractRate = (Integer)GasConduitConfig.tier1_extractRate.get();
        for (EnumFacing dir : this.externalConnections) {
            int used;
            IGasHandler extTank;
            GasStack couldDrain;
            if (!this.autoExtractForDir(dir) || (couldDrain = GasUtil.getGasStack(extTank = this.getExternalHandler(dir), dir.func_176734_d())) == null || !this.canReceiveGas(dir, couldDrain.getGas()) || !extTank.canDrawGas(dir.func_176734_d(), couldDrain.getGas())) continue;
            if (couldDrain.amount > tier1ExtractRate) {
                couldDrain.amount = tier1ExtractRate;
            }
            if ((used = this.pushGas(dir, couldDrain, true, this.network == null ? -1 : this.network.getNextPushToken())) <= 0) continue;
            couldDrain.amount = used;
            extTank.drawGas(dir.func_176734_d(), couldDrain.amount, true);
            if (this.network != null && this.network.getGasType() == null) {
                this.network.setGasType(couldDrain);
            }
            this.ticksSinceFailedExtract = 0L;
        }
    }

    @Nonnull
    public GasTankInfo[] getTankInfo() {
        GasTankInfo[] gasTankInfoArray;
        if (this.network == null) {
            gasTankInfoArray = new GasTankInfo[]{};
        } else {
            GasTankInfo[] gasTankInfoArray2 = new GasTankInfo[1];
            gasTankInfoArray = gasTankInfoArray2;
            gasTankInfoArray2[0] = this.tank;
        }
        return gasTankInfoArray;
    }

    public int receiveGas(EnumFacing side, GasStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public GasStack drawGas(EnumFacing side, int maxDrain, boolean doDrain) {
        return this.canDrawGas(side, this.tank.getGasType()) ? this.tank.draw(maxDrain, doDrain) : null;
    }

    public int receiveGas(EnumFacing from, GasStack resource, boolean doFill, boolean doPush, int pushToken) {
        if (this.network == null) {
            Log.error((String)"The network for this conduit was null when asked to receiveGas. Please report this to the GasConduits github");
            return 0;
        }
        if (!this.network.canAcceptGas(resource)) {
            return 0;
        }
        this.network.setGasType(resource);
        resource = resource.copy();
        resource.amount = Math.min((Integer)GasConduitConfig.tier1_maxIO.get(), resource.amount);
        if (doPush) {
            return this.pushGas(from, resource, doFill, pushToken);
        }
        return this.tank.receive(resource, doFill);
    }

    private void updateStartPushDir() {
        EnumFacing newVal = this.getNextDir(this.startPushDir);
        boolean foundNewStart = false;
        while (newVal != this.startPushDir && !foundNewStart) {
            foundNewStart = this.containsConduitConnection(newVal) || this.containsExternalConnection(newVal);
            newVal = this.getNextDir(newVal);
        }
        this.startPushDir = newVal;
    }

    private EnumFacing getNextDir(@Nonnull EnumFacing dir) {
        return dir.ordinal() >= EnumFacing.field_82609_l.length - 1 ? EnumFacing.field_82609_l[0] : EnumFacing.field_82609_l[dir.ordinal() + 1];
    }

    private int pushGas(@Nullable EnumFacing from, GasStack pushStack, boolean doPush, int token) {
        if (token == this.currentPushToken || pushStack == null || pushStack.amount <= 0 || this.network == null) {
            return 0;
        }
        this.currentPushToken = token;
        int pushed = 0;
        int total = pushStack.amount;
        EnumFacing dir = this.startPushDir;
        GasStack toPush = pushStack.copy();
        int filledLocal = this.tank.receive(toPush, doPush);
        toPush.amount -= filledLocal;
        pushed += filledLocal;
        do {
            IGasHandler con;
            if (dir == from || !this.canOutputToDir(dir) || this.autoExtractForDir(dir)) continue;
            if (this.containsConduitConnection(dir)) {
                IGasConduit conduitCon = this.getGasConduit(dir);
                if (conduitCon == null) continue;
                int toCon = ((GasConduit)conduitCon).pushGas(dir.func_176734_d(), toPush, doPush, token);
                toPush.amount -= toCon;
                pushed += toCon;
                continue;
            }
            if (!this.containsExternalConnection(dir) || (con = this.getExternalHandler(dir)) == null || !con.canReceiveGas(dir.func_176734_d(), toPush.getGas())) continue;
            int toExt = con.receiveGas(dir.func_176734_d(), toPush, doPush);
            toPush.amount -= toExt;
            pushed += toExt;
            if (!doPush) continue;
            this.network.outputedToExternal(toExt);
        } while ((dir = this.getNextDir(dir)) != this.startPushDir && pushed < total);
        return pushed;
    }

    private IGasConduit getGasConduit(@Nonnull EnumFacing dir) {
        TileEntity ent = this.getBundle().getEntity();
        return (IGasConduit)ConduitUtil.getConduit((World)ent.func_145831_w(), (TileEntity)ent, (EnumFacing)dir, IGasConduit.class);
    }

    @Override
    public boolean canReceiveGas(EnumFacing from, Gas gas) {
        if (!this.getConnectionMode(from).acceptsInput() || this.network == null || gas == null) {
            return false;
        }
        return this.tank.getGas() == null || GasUtil.areGasesTheSame(gas, this.tank.getGasType());
    }

    @Override
    public boolean canDrawGas(EnumFacing from, Gas gas) {
        return this.getConnectionMode(from).acceptsOutput() && this.tank.getGasType() != null && gas != null && GasUtil.areGasesTheSame(this.tank.getGasType(), gas);
    }

    public void connectionsChanged() {
        super.connectionsChanged();
        this.updateTank();
    }

    @Nonnull
    public ItemStack createItem() {
        return new ItemStack(GasConduitObject.itemGasConduit.getItemNN(), 1, 0);
    }

    @Nonnull
    public IConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        if (!(network instanceof AbstractGasTankConduitNetwork)) {
            return false;
        }
        AbstractGasTankConduitNetwork n = (AbstractGasTankConduitNetwork)network;
        if (this.tank.getGas() == null) {
            this.tank.setGas(n.getGasType() == null ? null : n.getGasType().copy());
        } else if (n.getGasType() == null) {
            n.setGasType(this.tank.getGas());
        } else if (!this.tank.getGas().isGasEqual(n.getGasType())) {
            return false;
        }
        this.network = (GasConduitNetwork)network;
        return super.setNetwork(network);
    }

    public void clearNetwork() {
        this.network = null;
    }

    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit con) {
        if (!super.canConnectToConduit(direction, con) || !(con instanceof GasConduit)) {
            return false;
        }
        return GasConduitNetwork.areGasesCompatible(this.getGasType(), ((GasConduit)con).getGasType());
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        if (component.isCore()) {
            return ICON_CORE_KEY;
        }
        EnumFacing componentDirection = component.getDirection();
        if (this.getConnectionMode(componentDirection) == ConnectionMode.INPUT) {
            return this.getGasType() == null ? ICON_EMPTY_EXTRACT_KEY : ICON_EXTRACT_KEY;
        }
        if (this.getConnectionMode(componentDirection) == ConnectionMode.OUTPUT) {
            return this.getGasType() == null ? ICON_EMPTY_INSERT_KEY : ICON_INSERT_KEY;
        }
        return this.gasTypeLocked ? ICON_KEY_LOCKED : ICON_KEY;
    }

    @Override
    protected void updateTank() {
        int totalConnections = this.getConduitConnections().size() + this.getExternalConnections().size();
        this.tank.setMaxGas(totalConnections * 250);
    }

    @Override
    protected boolean canJoinNeighbour(IGasConduit n) {
        return n instanceof GasConduit;
    }

    @Override
    public AbstractGasTankConduitNetwork<? extends AbstractGasTankConduit> getTankNetwork() {
        return this.network;
    }

    @Override
    public IGasHandler getGasDir(@Nullable EnumFacing dir) {
        return dir != null ? new ConnectionGasConduitSide(dir) : this;
    }

    @Nonnull
    public GasConduitNetwork createNetworkForType() {
        return new GasConduitNetwork();
    }

    @Nonnull
    public Class<? extends IConduit> getCollidableType() {
        return GasConduit.class;
    }

    protected class ConnectionGasConduitSide
    extends AbstractGasConduit.ConnectionGasSide {
        public ConnectionGasConduitSide(EnumFacing side) {
            super(side);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int receiveGas(EnumFacing side, GasStack resource, boolean doFill) {
            if (this.canReceiveGas(side, resource.getGas()) && GasConduit.this.network != null && GasConduit.this.network.lockNetworkForFill()) {
                try {
                    int res = GasConduit.this.receiveGas(side, resource, doFill, true, GasConduit.this.network == null ? -1 : GasConduit.this.network.getNextPushToken());
                    if (doFill && GasConduit.this.externalConnections.contains(side) && GasConduit.this.network != null) {
                        GasConduit.this.network.addedFromExternal(res);
                    }
                    int n = res;
                    return n;
                }
                finally {
                    if (GasConduit.this.network != null) {
                        GasConduit.this.network.unlockNetworkFromFill();
                    }
                }
            }
            return 0;
        }
    }
}

