/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.world;

import com.google.common.base.Predicate;
import divinerpg.config.Config;
import divinerpg.config.OreInfo;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.DimensionRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenCustomOres
implements IWorldGenerator {
    public static WorldGenCustomOres instance = new WorldGenCustomOres();
    private Predicate<IBlockState> stonePredicate = BlockMatcher.func_177642_a((Block)Blocks.field_150348_b);
    private Predicate<IBlockState> netherPredicate = BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL);
    private Predicate<IBlockState> twilightPredicate = BlockMatcher.func_177642_a((Block)BlockRegistry.twilightStone);
    private WorldGenerator waterLake = new WorldGenLakes((Block)Blocks.field_150355_j);
    private WorldGenerator tarLake = new WorldGenLakes(BlockRegistry.smolderingTar);
    private WorldGenerator twilightStoneLake = new WorldGenLakes(BlockRegistry.twilightStone);
    private final Map<Integer, DimensionGen> dimensionGenerators = new HashMap<Integer, DimensionGen>(){
        {
            this.put(DimensionType.NETHER.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genNether(x$0, x$1, x$2, x$3));
            this.put(DimensionType.OVERWORLD.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genOverworld(x$0, x$1, x$2, x$3));
            this.put(DimensionRegistry.edenDimension.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genEden(x$0, x$1, x$2, x$3));
            this.put(DimensionRegistry.wildwoodDimension.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genWild(x$0, x$1, x$2, x$3));
            this.put(DimensionRegistry.apalachiaDimension.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genApalachia(x$0, x$1, x$2, x$3));
            this.put(DimensionRegistry.skythernDimension.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genSkythern(x$0, x$1, x$2, x$3));
            this.put(DimensionRegistry.mortumDimension.func_186068_a(), (rec$, x$0, x$1, x$2, x$3) -> rec$.genMortum(x$0, x$1, x$2, x$3));
        }
    };

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int dimensionId = world.field_73011_w.getDimension();
        if (this.dimensionGenerators.containsKey(dimensionId)) {
            this.dimensionGenerators.get(dimensionId).gen(this, world, random, chunkX, chunkZ);
        }
    }

    private boolean spawnOre(World world, Random random, IBlockState ore, Predicate<IBlockState> replacing, int chunkX, int chunkZ, OreInfo info) {
        return this.spawnOre(world, random, ore, replacing, chunkX, chunkZ, info.getMinY(), info.getMaxY(), info.getVienSize(), info.getTries());
    }

    private boolean spawnOre(World world, Random random, IBlockState ore, Predicate<IBlockState> replacing, int chunkX, int chunkZ, int minY, int maxY, int veinSize, int tries) {
        int height = this.getHeightOrThrow(minY, maxY);
        WorldGenMinable gen = new WorldGenMinable(ore, veinSize, replacing);
        if (!TerrainGen.generateOre((World)world, (Random)random, (WorldGenerator)gen, (BlockPos)new BlockPos(chunkX * 16, 0, chunkZ * 16), (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM)) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < tries; ++i) {
            BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), minY + random.nextInt(height + 1), chunkZ * 16 + random.nextInt(16));
            result |= gen.func_180709_b(world, random, pos);
        }
        return result;
    }

    private boolean spawnTwilightOre(World world, Random random, Block ore, int chunkX, int chunkZ) {
        return this.spawnOre(world, random, ore.func_176223_P(), this.twilightPredicate, chunkX, chunkZ, Config.twilight);
    }

    private boolean generateLake(World world, Random random, WorldGenerator generator, int chunkX, int chunkZ, int minY, int maxY, int chance) {
        if (random.nextInt(chance) != 0) {
            return false;
        }
        BlockPos pos = new BlockPos(chunkX * 16 + random.nextInt(16), minY + random.nextInt(this.getHeightOrThrow(minY, maxY) + 1), chunkZ * 16 + random.nextInt(16));
        return generator.func_180709_b(world, random, pos.func_177982_a(8, 0, 8));
    }

    private int getHeightOrThrow(int minY, int maxY) {
        int height = maxY - minY;
        if (height <= 0) {
            throw new IllegalArgumentException("Max Y equals or less min Y");
        }
        if (minY < 0 || maxY > 256) {
            throw new IllegalArgumentException("Ore Generated Out of Bounds");
        }
        return height;
    }

    private void genOverworld(World world, Random random, int chunkX, int chunkZ) {
        this.spawnOre(world, random, BlockRegistry.realmiteOre.func_176223_P(), this.stonePredicate, chunkX, chunkZ, Config.realmite);
        this.spawnOre(world, random, BlockRegistry.rupeeOre.func_176223_P(), this.stonePredicate, chunkX, chunkZ, Config.rupee);
        this.spawnOre(world, random, BlockRegistry.arlemiteOre.func_176223_P(), this.stonePredicate, chunkX, chunkZ, Config.arlemite);
        if (Config.generateTar) {
            this.generateLake(world, random, this.tarLake, chunkX, chunkZ, 0, 60, 8);
            this.generateLake(world, random, this.tarLake, chunkX, chunkZ, 61, 150, 80);
        }
    }

    private void genNether(World world, Random random, int chunkX, int chunkZ) {
        this.spawnOre(world, random, BlockRegistry.netheriteOre.func_176223_P(), this.netherPredicate, chunkX, chunkZ, Config.nether);
        this.spawnOre(world, random, BlockRegistry.bloodgemOre.func_176223_P(), this.netherPredicate, chunkX, chunkZ, Config.nether);
    }

    private void genEden(World world, Random random, int chunkX, int chunkZ) {
        this.spawnTwilightOre(world, random, BlockRegistry.edenOre, chunkX, chunkZ);
    }

    private void genWild(World world, Random random, int chunkX, int chunkZ) {
        this.spawnTwilightOre(world, random, BlockRegistry.wildwoodOre, chunkX, chunkZ);
    }

    private void genApalachia(World world, Random random, int chunkX, int chunkZ) {
        this.spawnTwilightOre(world, random, BlockRegistry.apalachiaOre, chunkX, chunkZ);
        this.generateLake(world, random, this.waterLake, chunkX, chunkZ, 0, 150, 16);
    }

    private void genSkythern(World world, Random random, int chunkX, int chunkZ) {
        this.spawnTwilightOre(world, random, BlockRegistry.skythernOre, chunkX, chunkZ);
    }

    private void genMortum(World world, Random random, int chunkX, int chunkZ) {
        int chance = MathHelper.func_76125_a((int)(300 / Config.twilight.getTries()), (int)1, (int)Integer.MAX_VALUE);
        if (this.generateLake(world, random, this.twilightStoneLake, chunkX, chunkZ, 50, 70, chance)) {
            this.spawnOre(world, random, BlockRegistry.mortumOre.func_176223_P(), this.twilightPredicate, chunkX, chunkZ, 50, 70, Config.twilight.getVienSize() * 3, Config.twilight.getTries() * 3);
        }
    }

    @FunctionalInterface
    static interface DimensionGen {
        public void gen(WorldGenCustomOres var1, World var2, Random var3, int var4, int var5);
    }
}

