/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.iceika;

import divinerpg.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.MapGenBase;

public class IceikaCaves
extends MapGenBase {
    protected static final IBlockState BLOCK_AIR = Blocks.field_150350_a.func_176223_P();

    protected void generateLargeCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double xx, double yy, double zz) {
        this.generateCaveNode(seed, chunkX, chunkZ, primer, xx, yy, zz, 1.0f + this.field_75038_b.nextFloat() * 3.0f, 0.0f, 0.0f, -1, -1, this.field_75038_b.nextDouble() * 0.5 + 0.3);
    }

    public void func_186125_a(World worldIn, int x, int z, ChunkPrimer primer) {
        int i = this.field_75040_a;
        this.field_75039_c = worldIn;
        this.field_75038_b.setSeed(worldIn.func_72905_C());
        long j = this.field_75038_b.nextLong();
        long k = this.field_75038_b.nextLong();
        for (int l = x - i; l <= x + i; ++l) {
            for (int i1 = z - i; i1 <= z + i; ++i1) {
                long j1 = (long)l * j;
                long k1 = (long)i1 * k;
                this.field_75038_b.setSeed(j1 ^ k1 ^ worldIn.func_72905_C());
                this.func_180701_a(worldIn, l, i1, x, z, primer);
            }
        }
    }

    protected void generateCaveNode(long seed, int chunkX, int chunkZ, ChunkPrimer primer, double xx, double yy, double zz, float innerSize, float xzAngle, float yAngle, int par15, int par16, double heightMp) {
        boolean steep;
        double centerX = chunkX * 16 + 8;
        double centerZ = chunkZ * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random rand = new Random(seed);
        if (par16 <= 0) {
            int j1 = this.field_75040_a * 16 - 16;
            par16 = j1 - rand.nextInt(j1 / 4);
        }
        boolean flag = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            flag = true;
        }
        int k1 = rand.nextInt(par16 / 2) + par16 / 4;
        boolean bl = steep = rand.nextInt(6) == 0;
        while (par15 < par16) {
            double xzRange = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * innerSize * 1.0f);
            double yRange = xzRange * heightMp;
            float f5 = MathHelper.func_76134_b((float)yAngle);
            float f6 = MathHelper.func_76126_a((float)yAngle);
            xx += (double)(MathHelper.func_76134_b((float)xzAngle) * f5);
            yy += (double)f6;
            zz += (double)(MathHelper.func_76126_a((float)xzAngle) * f5);
            yAngle = steep ? (yAngle *= 0.92f) : (yAngle *= 0.7f);
            yAngle += f4 * 0.1f;
            xzAngle += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 2.0f;
            f3 += (rand.nextFloat() - rand.nextFloat()) * rand.nextFloat() * 4.0f;
            if (!flag && par15 == k1 && innerSize > 1.0f) {
                this.generateCaveNode(rand.nextLong(), chunkX, chunkZ, primer, xx, yy, zz, rand.nextFloat() * 0.5f + 0.5f, xzAngle - 1.5707964f, yAngle / 3.0f, par15, par16, 1.0);
                this.generateCaveNode(rand.nextLong(), chunkX, chunkZ, primer, xx, yy, zz, rand.nextFloat() * 0.5f + 0.5f, xzAngle + 1.5707964f, yAngle / 3.0f, par15, par16, 1.0);
                return;
            }
            if (flag || rand.nextInt(4) != 0) {
                double diffX = xx - centerX;
                double diffZ = zz - centerZ;
                double d10 = par16 - par15;
                double radius = innerSize + 2.0f + 16.0f;
                if (diffX * diffX + diffZ * diffZ - d10 * d10 > radius * radius) {
                    return;
                }
                if (xx >= centerX - 16.0 - xzRange * 2.0 && zz >= centerZ - 16.0 - xzRange * 2.0 && xx <= centerX + 16.0 + xzRange * 2.0 && zz <= centerZ + 16.0 + xzRange * 2.0) {
                    int px;
                    int minX = MathHelper.func_76128_c((double)(xx - xzRange)) - chunkX * 16 - 1;
                    int maxX = MathHelper.func_76128_c((double)(xx + xzRange)) - chunkX * 16 + 1;
                    int minY = MathHelper.func_76128_c((double)(yy - yRange)) - 1;
                    int maxY = MathHelper.func_76128_c((double)(yy + yRange)) + 1;
                    int minZ = MathHelper.func_76128_c((double)(zz - xzRange)) - chunkZ * 16 - 1;
                    int maxZ = MathHelper.func_76128_c((double)(zz + xzRange)) - chunkZ * 16 + 1;
                    if (minX < 0) {
                        minX = 0;
                    }
                    if (maxX > 16) {
                        maxX = 16;
                    }
                    if (minY < 6) {
                        minY = 6;
                    }
                    if (maxY > 124) {
                        maxY = 124;
                    }
                    if (minZ < 0) {
                        minZ = 0;
                    }
                    if (maxZ > 16) {
                        maxZ = 16;
                    }
                    boolean preventGeneration = false;
                    for (px = minX; !preventGeneration && px < maxX; ++px) {
                        for (int pz = minZ; !preventGeneration && pz < maxZ; ++pz) {
                            for (int py = maxY + 1; !preventGeneration && py >= minY - 1; --py) {
                                if (py < 0 || py >= 128 || py == minY - 1 || px == minX || px == maxX - 1 || pz == minZ || pz == maxZ - 1) continue;
                                py = minY;
                            }
                        }
                    }
                    if (!preventGeneration) {
                        for (px = minX; px < maxX; ++px) {
                            double xDiff = ((double)(px + chunkX * 16) + 0.5 - xx) / xzRange;
                            for (int pz = minZ; pz < maxZ; ++pz) {
                                double zDiff = ((double)(pz + chunkZ * 16) + 0.5 - zz) / xzRange;
                                if (!(xDiff * xDiff + zDiff * zDiff < 1.0)) continue;
                                for (int py = maxY - 1; py >= minY; --py) {
                                    IBlockState state;
                                    double yDiff = ((double)py + 0.5 - yy) / yRange;
                                    if (!(yDiff > -0.7) || !(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff < 1.0) || (state = primer.func_177856_a(px, py, pz)).func_177230_c() != BlockRegistry.frozenStone && state.func_177230_c() != BlockRegistry.frozenDirt && state.func_177230_c() != BlockRegistry.frozenGrass) continue;
                                    primer.func_177855_a(px, py, pz, BLOCK_AIR);
                                }
                            }
                        }
                        if (flag) break;
                    }
                }
            }
            ++par15;
        }
    }

    protected void func_180701_a(World worldIn, int chunkX, int chunkZ, int localX, int localZ, ChunkPrimer primer) {
        int caveAmount = this.field_75038_b.nextInt(this.field_75038_b.nextInt(25) + 1);
        if (this.field_75038_b.nextInt(10) != 0) {
            caveAmount = 0;
        }
        for (int iter = 0; iter < caveAmount; ++iter) {
            int smallCaves;
            double xx = chunkX * 16 + this.field_75038_b.nextInt(16);
            double yy = 68.0 + this.field_75038_b.nextGaussian() * 48.0;
            double zz = chunkZ * 16 + this.field_75038_b.nextInt(16);
            int n = smallCaves = this.field_75038_b.nextBoolean() && this.field_75038_b.nextBoolean() ? 2 : 1;
            if (this.field_75038_b.nextInt(8) == 0) {
                this.generateLargeCaveNode(this.field_75038_b.nextLong(), localX, localZ, primer, xx, yy, zz);
                smallCaves += this.field_75038_b.nextInt(3);
            }
            for (int cave = 0; cave < smallCaves; ++cave) {
                float xzAngle = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float yAngle = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float innerSize = this.field_75038_b.nextFloat() * 2.5f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    innerSize *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() + 1.0f;
                }
                this.generateCaveNode(this.field_75038_b.nextLong(), localX, localZ, primer, xx, yy, zz, innerSize, xzAngle, yAngle, 0, 0, 1.0);
            }
        }
    }
}

