/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.addons;

import javax.annotation.Nullable;
import net.blay09.mods.craftingtweaks.addons.ProviderCraftingSilo;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.SimpleTweakProvider;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftingTweaksAddons {
    public static final Logger logger = LogManager.getLogger();

    public static void postInit(FMLPostInitializationEvent event) {
        CraftingTweaksAddons.progressiveautomation();
        if (Loader.isModLoaded((String)"storagesilo")) {
            CraftingTweaksAddons.registerProvider("uk.binarycraft.storagesilo.blocks.craftingsilo.ContainerCraftingSilo", new ProviderCraftingSilo());
        }
    }

    private static void progressiveautomation() {
        SimpleTweakProvider provider = CraftingTweaksAddons.registerSimpleProvider("progressiveautomation", "com.vanhal.progressiveautomation.gui.container.ContainerCrafter");
        if (provider != null) {
            provider.setGrid(2, 9);
            provider.setTweakRotate(true, true, 0, 0);
            provider.setTweakBalance(false, false, 0, 0);
            provider.setTweakClear(true, true, 0, 0);
            provider.setAlignToGrid(EnumFacing.WEST);
        }
    }

    @Nullable
    private static SimpleTweakProvider registerSimpleProvider(String modid, String className) {
        try {
            if (Loader.isModLoaded((String)modid)) {
                return CraftingTweaksAPI.registerSimpleProvider(modid, Class.forName(className));
            }
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not register Crafting Tweaks addon for {} - internal names have changed.", (Object)modid);
        }
        return null;
    }

    private static void registerProvider(String className, TweakProvider provider) {
        try {
            CraftingTweaksAPI.registerProvider(Class.forName(className), provider);
        }
        catch (ClassNotFoundException e) {
            logger.error("Could not register Crafting Tweaks addon for {} - internal names have changed.", (Object)provider.getModId());
        }
    }
}

