/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.util;

import com.google.common.base.Preconditions;
import net.minecraft.util.ResourceLocation;

public final class AlignmentUtil {
    public static final int SLOT_SIZE = 18;
    public static final ResourceLocation SLOT_BACKGROUND = new ResourceLocation("buildinggadgets", "textures/gui/item_slot_background.png");

    private AlignmentUtil() {
    }

    public static int getXForAlignedRight(int width, int rightX) {
        return rightX - width;
    }

    public static int getXForAlignedCenter(int width, int leftX, int rightX) {
        Preconditions.checkArgument((leftX < rightX ? 1 : 0) != 0);
        return leftX + (rightX - leftX) / 2 - width / 2;
    }

    public static int getYForAlignedBottom(int height, int bottomY) {
        return bottomY - height;
    }

    public static int getYForAlignedCenter(int height, int topY, int bottomY) {
        Preconditions.checkArgument((bottomY > topY ? 1 : 0) != 0);
        return topY + (bottomY - topY) / 2 - height / 2;
    }
}

