/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.script.command.entity;

import java.util.Collection;
import java.util.Iterator;
import me.superckl.api.biometweaker.event.BiomeTweakEvent;
import me.superckl.api.biometweaker.script.AutoRegister;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.script.command.ScriptCommand;
import me.superckl.api.superscript.util.WarningHelper;
import me.superckl.biometweaker.BiomeTweaker;
import me.superckl.biometweaker.script.object.BiomesScriptObject;
import me.superckl.biometweaker.script.object.TweakerScriptObject;
import me.superckl.biometweaker.util.EntityHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ScriptCommandAddRemoveSpawn
extends ScriptCommand {
    private final BiomePackage pack;
    private final boolean remove;
    private final EnumCreatureType type;
    private final String entityClass;
    private final int weight;
    private final int minCount;
    private final int maxCount;

    @AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="addSpawn")
    @AutoRegister.ParameterOverrides(value={@AutoRegister.ParameterOverride(exceptionKey="nonNegInt", parameterIndex=3), @AutoRegister.ParameterOverride(exceptionKey="nonNegInt", parameterIndex=4), @AutoRegister.ParameterOverride(exceptionKey="nonNegInt", parameterIndex=5)})
    public ScriptCommandAddRemoveSpawn(BiomePackage pack, String entityClass, EnumCreatureType type, int weight, int minCount, int maxCount) {
        this(pack, false, type, entityClass, weight, minCount, maxCount);
    }

    @AutoRegister(classes={BiomesScriptObject.class, TweakerScriptObject.class}, name="removeSpawn")
    public ScriptCommandAddRemoveSpawn(BiomePackage pack, String entityClass, EnumCreatureType type) {
        this(pack, true, type, entityClass, 0, 0, 0);
    }

    @Override
    public void perform() throws Exception {
        Class<? extends Entity> clazz2 = EntityHelper.getEntityClass(this.entityClass);
        if (clazz2 == null) {
            throw new IllegalArgumentException("Failed to find entity class: " + this.entityClass);
        }
        if (!EntityLiving.class.isAssignableFrom(clazz2)) {
            throw new IllegalArgumentException("entity class " + this.entityClass + " is not assignable to EntityLiving. It cannot be spawned!");
        }
        Class clazz = (Class)WarningHelper.uncheckedCast(clazz2);
        Biome.SpawnListEntry entry = new Biome.SpawnListEntry(clazz, this.weight, this.minCount, this.maxCount);
        Iterator<Biome> it = this.pack.getIterator();
        while (it.hasNext()) {
            Biome biome = it.next();
            if (this.remove && MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.RemoveSpawn(this, biome, this.type, clazz)) || !this.remove && MinecraftForge.EVENT_BUS.post((Event)new BiomeTweakEvent.AddSpawn(this, biome, entry))) continue;
            if (this.remove) {
                this.removeEntry(clazz, biome.func_76747_a(this.type));
            } else {
                biome.func_76747_a(this.type).add(new Biome.SpawnListEntry(clazz, this.weight, this.minCount, this.maxCount));
            }
            BiomeTweaker.getInstance().onTweak(Biome.func_185362_a((Biome)biome));
        }
    }

    private void removeEntry(Class<?> clazz, Collection<Biome.SpawnListEntry> coll) {
        Iterator<Biome.SpawnListEntry> it = coll.iterator();
        while (it.hasNext()) {
            if (!it.next().field_76300_b.getName().equals(clazz.getName())) continue;
            it.remove();
        }
    }

    private ScriptCommandAddRemoveSpawn(BiomePackage pack, boolean remove, EnumCreatureType type, String entityClass, int weight, int minCount, int maxCount) {
        this.pack = pack;
        this.remove = remove;
        this.type = type;
        this.entityClass = entityClass;
        this.weight = weight;
        this.minCount = minCount;
        this.maxCount = maxCount;
    }
}

