/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.ar.com.hjg.pngj;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import me.superckl.biometweaker.ar.com.hjg.pngj.BufferedStreamFeeder;
import me.superckl.biometweaker.ar.com.hjg.pngj.ChunkReader;
import me.superckl.biometweaker.ar.com.hjg.pngj.ChunkSeqReaderPng;
import me.superckl.biometweaker.ar.com.hjg.pngj.chunks.PngChunk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngReaderFilter
extends FilterInputStream {
    private ChunkSeqReaderPng chunkseq = this.createChunkSequenceReader();

    public PngReaderFilter(InputStream arg0) {
        super(arg0);
    }

    protected ChunkSeqReaderPng createChunkSequenceReader() {
        return new ChunkSeqReaderPng(true){

            public boolean shouldSkipContent(int len, String id) {
                return super.shouldSkipContent(len, id) || id.equals("IDAT");
            }

            protected boolean shouldCheckCrc(int len, String id) {
                return false;
            }

            protected void postProcessChunk(ChunkReader chunkR) {
                super.postProcessChunk(chunkR);
            }
        };
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.chunkseq.close();
    }

    @Override
    public int read() throws IOException {
        int r = super.read();
        if (r > 0) {
            this.chunkseq.feedAll(new byte[]{(byte)r}, 0, 1);
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.chunkseq.feedAll(b, off, res);
        }
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int res = super.read(b);
        if (res > 0) {
            this.chunkseq.feedAll(b, 0, res);
        }
        return res;
    }

    public void readUntilEndAndClose() throws IOException {
        BufferedStreamFeeder br = new BufferedStreamFeeder(this.in);
        while (!this.chunkseq.isDone() && br.hasMoreToFeed()) {
            br.feed(this.chunkseq);
        }
        this.close();
    }

    public List<PngChunk> getChunksList() {
        return this.chunkseq.getChunks();
    }

    public ChunkSeqReaderPng getChunkseq() {
        return this.chunkseq;
    }
}

