/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.biometweaker.script.pack;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.superckl.api.biometweaker.script.pack.BiomePackage;
import me.superckl.api.superscript.util.CollectionHelper;
import net.minecraft.world.biome.Biome;

public class IntersectBiomesPackage
extends BiomePackage {
    List<BiomePackage> packs = new ArrayList<BiomePackage>();

    public IntersectBiomesPackage(BiomePackage ... packs) {
        Collections.addAll(this.packs, packs);
    }

    @Override
    public Iterator<Biome> getIterator() {
        if (this.packs.size() == 0) {
            return Collections.emptyIterator();
        }
        ArrayList lists = new ArrayList();
        for (BiomePackage pack : this.packs) {
            ArrayList list = new ArrayList();
            Iterators.addAll(list, pack.getIterator());
            lists.add(list);
        }
        ArrayList intersect = new ArrayList((Collection)lists.get(0));
        Iterator it = intersect.iterator();
        while (it.hasNext()) {
            if (CollectionHelper.allContains(it.next(), lists)) continue;
            it.remove();
        }
        return intersect.iterator();
    }

    @Override
    public boolean supportsEarlyRawIds() {
        for (BiomePackage pack : this.packs) {
            if (pack.supportsEarlyRawIds()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Integer> getRawIds() {
        if (this.packs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<List<Integer>> ints = new ArrayList<List<Integer>>();
        for (BiomePackage pack : this.packs) {
            ints.add(pack.getRawIds());
        }
        ArrayList<Integer> intersect = new ArrayList<Integer>((Collection)ints.get(0));
        Iterator it = intersect.iterator();
        while (it.hasNext()) {
            if (CollectionHelper.allContains(it.next(), ints)) continue;
            it.remove();
        }
        return intersect;
    }
}

