/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network.packet.server;

import io.netty.buffer.ByteBuf;
import jds.bibliocraft.Config;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.network.packet.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BiblioRecipeCraft
implements IMessage {
    ItemStack recipeBook;
    int inventorySlot;

    public BiblioRecipeCraft() {
    }

    public BiblioRecipeCraft(ItemStack recipeBook, int inventorySlot) {
        this.recipeBook = recipeBook;
        this.inventorySlot = inventorySlot;
    }

    public void fromBytes(ByteBuf buf) {
        this.recipeBook = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.inventorySlot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.recipeBook);
        buf.writeInt(this.inventorySlot);
    }

    public static class Handler
    implements IMessageHandler<BiblioRecipeCraft, IMessage> {
        public IMessage onMessage(BiblioRecipeCraft message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(() -> {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                ItemStack recipeBook = message.recipeBook;
                int inventorySlot = message.inventorySlot;
                if (Config.enableRecipeBookCrafting) {
                    if (recipeBook != ItemStack.field_190927_a && recipeBook.func_77973_b() instanceof ItemRecipeBook) {
                        NonNullList bookGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
                        ItemStack resultStack = ItemStack.field_190927_a;
                        NBTTagCompound nbt = recipeBook.func_77978_p();
                        if (nbt != null) {
                            NBTTagList tagList = nbt.func_150295_c("grid", 10);
                            bookGrid = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
                            for (int i = 0; i < 9; ++i) {
                                ItemStack nbtStack;
                                NBTTagCompound tag = tagList.func_150305_b(i);
                                byte slot = tag.func_74771_c("Slot");
                                if (slot < 0 || slot >= 9 || (nbtStack = new ItemStack(tag)) == ItemStack.field_190927_a) continue;
                                bookGrid.set((int)slot, (Object)nbtStack);
                            }
                            NBTTagCompound resultTag = nbt.func_74775_l("result");
                            if (resultTag != null) {
                                resultStack = new ItemStack(resultTag);
                            }
                        }
                        if (resultStack != ItemStack.field_190927_a) {
                            if (Utils.checkForValidRecipeIngredients((NonNullList<ItemStack>)bookGrid, player, false)) {
                                Container contained = new Container(){

                                    public boolean func_75145_c(EntityPlayer p_75145_1_) {
                                        return false;
                                    }
                                };
                                InventoryCrafting playerCraftMatrix = new InventoryCrafting(contained, 3, 3);
                                for (int i = 0; i < bookGrid.size(); ++i) {
                                    playerCraftMatrix.func_70299_a(i, (ItemStack)bookGrid.get(i));
                                }
                                ItemStack result = CraftingManager.func_82787_a((InventoryCrafting)playerCraftMatrix, (World)player.field_70170_p);
                                if (result != ItemStack.field_190927_a) {
                                    if (Utils.checkForValidRecipeIngredients((NonNullList<ItemStack>)bookGrid, player, true)) {
                                        if (!player.field_71071_by.func_70441_a(result.func_77946_l())) {
                                            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(result.func_77973_b(), result.func_190916_E(), result.func_77952_i()));
                                            if (result.func_77942_o()) {
                                                entityItem.func_92059_d().func_77982_d(result.func_77978_p().func_74737_b());
                                            }
                                            entityItem.field_70159_w = 0.0;
                                            entityItem.field_70181_x = 0.0;
                                            entityItem.field_70179_y = 0.0;
                                            player.field_70170_p.func_72838_d((Entity)entityItem);
                                        }
                                        Utils.sendARecipeBookTextPacket(player, result.func_82833_r() + " " + I18n.func_74838_a((String)"gui.recipe.crafted"), inventorySlot);
                                    } else {
                                        Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.failed"), inventorySlot);
                                    }
                                    return;
                                }
                                Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.invalid"), inventorySlot);
                                return;
                            }
                            Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.missing"), inventorySlot);
                            return;
                        }
                        Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.invalid"), inventorySlot);
                        return;
                    }
                    Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.wrong"), inventorySlot);
                } else {
                    Utils.sendARecipeBookTextPacket(player, I18n.func_74838_a((String)"gui.recipe.disabled"), inventorySlot);
                }
            });
            return null;
        }
    }
}

