/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.resources.textures;

import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.colors.GuiColorStatic;
import betterquesting.api2.client.gui.resources.colors.IGuiColor;
import betterquesting.api2.client.gui.resources.textures.IGuiTexture;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class PolyTexture
implements IGuiTexture {
    private final IGuiColor defColor;
    private final boolean shadow;
    private final double[] verts;
    private int borderSize = 1;
    private IGuiColor borColor = new GuiColorStatic(-1);

    public PolyTexture(int points, double rotation, boolean shadow, @Nonnull IGuiColor color) {
        int i;
        this.defColor = color;
        this.shadow = shadow;
        if (points <= 0) {
            points = 32;
        }
        this.verts = new double[points * 2];
        double min = 1.0E-4;
        for (i = 0; i < points; ++i) {
            double angle = 360.0 * ((double)i / (double)points);
            double x = -Math.sin(Math.toRadians(angle + rotation));
            double y = -Math.cos(Math.toRadians(angle + rotation));
            min = Math.max(min, Math.max(Math.abs(x), Math.abs(y)));
            this.verts[i * 2] = x;
            this.verts[i * 2 + 1] = y;
        }
        for (i = 0; i < this.verts.length; ++i) {
            double x = this.verts[i];
            this.verts[i] = x = x / 2.0 / min + 0.5;
        }
    }

    public PolyTexture(@Nonnull double[] verts, boolean shadow, IGuiColor color) {
        this.defColor = color;
        this.shadow = shadow;
        this.verts = new double[verts.length];
        System.arraycopy(verts, 0, this.verts, 0, verts.length);
    }

    public IGuiTexture setBorder(int size, IGuiColor color) {
        this.borderSize = size;
        this.borColor = color;
        return this;
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick) {
        this.drawTexture(x, y, width, height, zDepth, partialTick, this.defColor);
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float zDepth, float partialTick, IGuiColor color) {
        int index;
        int i;
        if (width <= 0 || height <= 0) {
            return;
        }
        GlStateManager.func_179094_E();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        int w = this.shadow ? width - 2 : width;
        int h = this.shadow ? height - 2 : height;
        int dx = this.shadow ? x + 1 : x;
        int dy = this.shadow ? y + 1 : y;
        int sx = x + 2;
        int sy = y + 2;
        int points = this.verts.length / 2;
        if (this.shadow) {
            GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
            vertexbuffer.func_181668_a(9, DefaultVertexFormats.field_181705_e);
            for (i = 0; i < points + 1; ++i) {
                index = i % points * 2;
                vertexbuffer.func_181662_b((double)sx + (double)w * this.verts[index], (double)sy + (double)h * this.verts[index + 1], 0.0).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        color.applyGlColor();
        vertexbuffer.func_181668_a(9, DefaultVertexFormats.field_181705_e);
        for (i = 0; i < points + 1; ++i) {
            index = i % points * 2;
            vertexbuffer.func_181662_b((double)dx + (double)w * this.verts[index], (double)dy + (double)h * this.verts[index + 1], 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        if (this.borderSize > 0 && this.borColor != null) {
            this.borColor.applyGlColor();
            vertexbuffer.func_181668_a(8, DefaultVertexFormats.field_181705_e);
            for (i = 0; i < points + 1; ++i) {
                index = i % points * 2;
                double bx = (this.verts[index] - 0.5) * (double)(-this.borderSize) * 2.0;
                double by = (this.verts[index + 1] - 0.5) * (double)(-this.borderSize) * 2.0;
                vertexbuffer.func_181662_b((double)dx + (double)w * this.verts[index] + bx, (double)dy + (double)h * this.verts[index + 1] + by, 0.0).func_181675_d();
                vertexbuffer.func_181662_b((double)dx + (double)w * this.verts[index], (double)dy + (double)h * this.verts[index + 1], 0.0).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @Override
    public ResourceLocation getTexture() {
        return null;
    }

    @Override
    public IGuiRect getBounds() {
        return null;
    }
}

