/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.util;

import com.bloodnbonesgaming.bnbgamingcore.core.BNBGamingCorePlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ClassReader;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ObfHelper;

public class ClassExtensionHelper {
    private static String currentClass;
    private static final List<String> superclasses;

    public static boolean doesClassExtend(String className, String targetSuperInternalClassName, byte[] basicClass) {
        if (!className.equals(currentClass)) {
            currentClass = className;
            ClassExtensionHelper.fillSuperclassArray(basicClass);
        }
        return superclasses.contains(targetSuperInternalClassName);
    }

    private static void fillSuperclassArray(byte[] basicClass) {
        superclasses.clear();
        try {
            ClassReader classReader = new ClassReader(basicClass);
            while (classReader != null && ASMHelper.classHasSuper(classReader)) {
                String immediateSuperName = classReader.getSuperName();
                superclasses.add(immediateSuperName);
                try {
                    classReader = ASMHelper.getClassReaderForClassName(ObfHelper.getInternalClassName(immediateSuperName));
                }
                catch (IOException e) {
                    BNBGamingCorePlugin.log.debug("Caught IOException while creating ClassReader for " + ObfHelper.getInternalClassName(immediateSuperName));
                    break;
                }
            }
        }
        catch (Exception e) {
            BNBGamingCorePlugin.log.debug("Caught Exception while attempting to get class extensions for " + currentClass);
        }
    }

    static {
        superclasses = new ArrayList<String>();
    }
}

