/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.util;

import com.bloodnbonesgaming.bnbgamingcore.core.util.ClassExtensionHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ObfHelper;

public class ASMUtils {
    public static boolean doesClassEqualOrExtend(String className, ObfNameHelper.Classes clazz, byte[] basicClass) {
        return ASMUtils.doesClassEqual(className, clazz) || ClassExtensionHelper.doesClassExtend(className, clazz.getInternalName(), basicClass);
    }

    public static boolean doesClassEqual(String className, ObfNameHelper.Classes clazz) {
        return className.equals(clazz.getName());
    }

    public static MethodNode findMethodNodeOfClass(ClassNode classNode, String methodName, String methodDesc) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals(methodName) || methodDesc != null && !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static FieldNode findFieldNodeOfClass(ClassNode classNode, String fieldName, String fieldDesc) {
        for (FieldNode field : classNode.fields) {
            if (fieldName != null && !field.name.equals(fieldName) || fieldDesc != null && !field.desc.equals(fieldDesc)) continue;
            return field;
        }
        return null;
    }

    public static boolean addAnnotationToField(ClassNode classNode, String fieldName, String fieldDesc, Class annotationClass, Object ... annotationFields) {
        FieldNode fieldNode = ASMUtils.findFieldNodeOfClass(classNode, fieldName, fieldDesc);
        if (fieldNode == null) {
            return false;
        }
        AnnotationNode annotation = new AnnotationNode(Type.getDescriptor((Class)annotationClass));
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < annotationFields.length; ++i) {
            values.add(i, annotationFields[i]);
        }
        annotation.values = values;
        if (fieldNode.visibleAnnotations == null) {
            ArrayList<AnnotationNode> annotationList = new ArrayList<AnnotationNode>();
            annotationList.add(annotation);
            fieldNode.visibleAnnotations = annotationList;
        } else {
            fieldNode.visibleAnnotations.add(annotation);
        }
        return true;
    }

    public static boolean makeFieldTransient(ClassNode classNode, String fieldName, String fieldDesc) {
        FieldNode field = ASMUtils.findFieldNodeOfClass(classNode, fieldName, fieldDesc);
        if (field == null) {
            return false;
        }
        field.access |= 0x80;
        return true;
    }

    public static boolean doesClassImplement(ClassReader classReader, String targetInterfaceInternalClassName) {
        List<String> immediateInterfaces = Arrays.asList(classReader.getInterfaces());
        for (String immediateInterface : immediateInterfaces) {
            if (!immediateInterface.equals(targetInterfaceInternalClassName)) continue;
            return true;
        }
        try {
            if (ASMHelper.classHasSuper(classReader)) {
                return ASMUtils.doesClassImplement(ASMHelper.getClassReaderForClassName(ObfHelper.getInternalClassName(classReader.getSuperName())), targetInterfaceInternalClassName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static LabelNode findLabelNode(InsnList instructions, int count) {
        ListIterator iterator = instructions.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            AbstractInsnNode node = (AbstractInsnNode)iterator.next();
            if (node.getType() != 8 || i++ != count) continue;
            return (LabelNode)node;
        }
        return null;
    }

    public static LabelNode findPreviousLabelNode(AbstractInsnNode start) {
        for (AbstractInsnNode node = start; node != null; node = node.getPrevious()) {
            if (node.getType() != 8) continue;
            return (LabelNode)node;
        }
        return null;
    }
}

