/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.advancements;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleGrantCriterionEvent
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqual(transformedName, ObfNameHelper.Classes.ICRITERIONTRIGGER$LISTENER)) {
            String methodDesc;
            String methodName;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.LISTENER_GRANT_CRITERION.getName(), methodDesc = ObfNameHelper.Methods.LISTENER_GRANT_CRITERION.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addGrantCriterionEventHook(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    return ASMHelper.writeClassToBytes(classNode, 3);
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ICRITERIONTRIGGER$LISTENER.getName()};
    }

    @Override
    public String getModuleName() {
        return "grantCriterionEvent";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean addGrantCriterionEventHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.findFirstInstruction(method);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name, transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)ObfNameHelper.Fields.ADVANCEMENT.toInsnNode(180));
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 0));
        toInject.add((AbstractInsnNode)ObfNameHelper.Fields.CRITERION_NAME.toInsnNode(180));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_GRANT_CRITERION.toInsnNode(184));
        LabelNode label = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label));
        toInject.add((AbstractInsnNode)new InsnNode(177));
        toInject.add((AbstractInsnNode)label);
        method.instructions.insertBefore(target, toInject);
        return true;
    }
}

