/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.layer;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.world.biome.base.AtumBiome;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;

public class GenLayerAtumBiome
extends GenLayer {
    private List<BiomeManager.BiomeEntry> biomes = Lists.newArrayList();
    private final ChunkGeneratorSettings settings;

    public GenLayerAtumBiome(long seed, ChunkGeneratorSettings settings) {
        super(seed);
        this.settings = settings;
        for (AtumBiome biome : AtumRegistry.BIOMES) {
            BiomeManager.BiomeEntry entry = new BiomeManager.BiomeEntry((Biome)biome, biome.getWeight());
            if (biome.getWeight() == 0) continue;
            this.biomes.add(entry);
        }
    }

    @Nonnull
    public int[] func_75904_a(int x, int z, int width, int areaHeight) {
        int[] cache = IntCache.func_76445_a((int)(width * areaHeight));
        int totalWeight = WeightedRandom.func_76272_a(this.biomes);
        for (int i = 0; i < areaHeight; ++i) {
            for (int j = 0; j < width; ++j) {
                this.func_75903_a(j + x, i + z);
                if (this.settings != null && this.settings.field_177779_F >= 0) {
                    cache[j + i * width] = this.settings.field_177779_F;
                    continue;
                }
                BiomeManager.BiomeEntry biome = (BiomeManager.BiomeEntry)WeightedRandom.func_180166_a(this.biomes, (int)this.func_75902_a(totalWeight));
                cache[j + i * width] = AtumBiome.func_185362_a((Biome)biome.biome);
            }
        }
        return cache;
    }
}

