/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemTexturedArmor
extends ItemArmor {
    private Item repairItem;
    private final String armorPieceName;
    private boolean isDyeable;
    private int damageModifier;

    public ItemTexturedArmor(ItemArmor.ArmorMaterial material, String name, EntityEquipmentSlot slot) {
        super(material, 0, slot);
        this.armorPieceName = name;
    }

    public ItemTexturedArmor setRepairItem(Item item) {
        this.repairItem = item;
        return this;
    }

    public ItemTexturedArmor setDyeable() {
        this.isDyeable = true;
        return this;
    }

    public ItemTexturedArmor setDamageModifier(int percentage) {
        this.damageModifier = percentage;
        return this;
    }

    public int getMaxDamage(@Nonnull ItemStack stack) {
        return this.damageModifier > 0 ? super.getMaxDamage(stack) + super.getMaxDamage(stack) * this.damageModifier / 100 : super.getMaxDamage(stack);
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return this.repairItem != null && repair.func_77973_b() == this.repairItem;
    }

    public String getArmorTexture(@Nonnull ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String armorModel = "atum:textures/armor/";
        return type == null ? armorModel + this.armorPieceName + ".png" : armorModel + this.armorPieceName + "_overlay.png";
    }

    public boolean hasOverlay(@Nonnull ItemStack stack) {
        return this.isDyeable();
    }

    public boolean isDyeable() {
        return this.isDyeable;
    }

    public boolean func_82816_b_(@Nonnull ItemStack stack) {
        return this.isDyeable() && stack.func_77978_p() != null && stack.func_77942_o() && stack.func_77978_p().func_150297_b("display", 10) && stack.func_77978_p().func_74775_l("display").func_150297_b("color", 3);
    }

    public int func_82814_b(@Nonnull ItemStack stack) {
        if (this.isDyeable()) {
            NBTTagCompound displayTag;
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null && (displayTag = tag.func_74775_l("display")).func_150297_b("color", 3)) {
                return displayTag.func_74762_e("color");
            }
            return -1;
        }
        return super.func_82814_b(stack);
    }

    public void func_82815_c(@Nonnull ItemStack stack) {
        NBTTagCompound displayTag;
        NBTTagCompound tag;
        if (this.isDyeable() && (tag = stack.func_77978_p()) != null && (displayTag = tag.func_74775_l("display")).func_74764_b("color")) {
            displayTag.func_82580_o("color");
        }
    }

    public void func_82813_b(@Nonnull ItemStack stack, int color) {
        if (this.isDyeable()) {
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            NBTTagCompound displayTag = tag.func_74775_l("display");
            if (!tag.func_150297_b("display", 10)) {
                tag.func_74782_a("display", (NBTBase)displayTag);
            }
            displayTag.func_74768_a("color", color);
        }
    }
}

