/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.ritual;

import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.util.blocks.IRitualAltar;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NecronomiconMassEnchantRitual
extends NecronomiconRitual {
    List<ItemStack> books = new ArrayList<ItemStack>();

    public NecronomiconMassEnchantRitual() {
        super("massEnchantment", 4, 50000.0f, new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR), new ItemStack(Items.field_151134_bR));
        this.setRitualParticle(EnumRitualParticle.GLYPHS);
    }

    @Override
    public boolean requiresItemSacrifice() {
        return true;
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRitualAltar) {
            IRitualAltar altar = (IRitualAltar)tile;
            if (altar.getItem().func_77973_b() == Items.field_151122_aG && !ACConfig.enchantBooks) {
                return false;
            }
            if (altar.getItem().func_77956_u()) {
                this.books = altar.getPedestals().stream().map(p -> p.getItem()).filter(i -> i.func_77953_t() == EnumRarity.UNCOMMON).collect(Collectors.toList());
                return this.books.size() == 8;
            }
        }
        return false;
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    protected void completeRitualServer(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IRitualAltar) {
            IRitualAltar altar = (IRitualAltar)tile;
            HashMap enchantments = new HashMap();
            this.books.stream().map(s -> ItemEnchantedBook.func_92110_g((ItemStack)s)).forEach(n -> {
                for (int i = 0; i < n.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = n.func_150305_b(i);
                    short id = nbttagcompound.func_74765_d("id");
                    int lvl = Math.min(nbttagcompound.func_74765_d("lvl"), ACConfig.enchantmentMaxLevel);
                    enchantments.merge(Integer.valueOf(id), lvl, (k, v) -> Math.min(k + v, ACConfig.enchantmentMaxLevel));
                }
            });
            if (!enchantments.isEmpty()) {
                if (altar.getItem().func_77973_b() == Items.field_151122_aG && ACConfig.enchantBooks) {
                    ItemStack book = new ItemStack(Items.field_151134_bR);
                    book.func_77982_d(new NBTTagCompound());
                    NBTTagList list = new NBTTagList();
                    enchantments.entrySet().stream().forEach(e -> {
                        NBTTagCompound nbt = new NBTTagCompound();
                        nbt.func_74777_a("id", ((Integer)e.getKey()).shortValue());
                        nbt.func_74777_a("lvl", ((Integer)e.getValue()).shortValue());
                        list.func_74742_a((NBTBase)nbt);
                    });
                    book.func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)list);
                    altar.setItem(book);
                } else if (altar.getItem().func_77973_b() != Items.field_151122_aG) {
                    EnchantmentHelper.func_82782_a(enchantments.entrySet().stream().collect(Collectors.toMap(e -> Enchantment.func_185262_c((int)((Integer)e.getKey())), e -> (Integer)e.getValue())), (ItemStack)altar.getItem());
                }
            }
        }
    }
}

