/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.energy.IEnergyCollector;
import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.lib.util.blocks.ISingletonInventory;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntitySacrificialAltar
extends TileEntity
implements IEnergyCollector,
ISingletonInventory,
ITickable {
    private ItemStack item = ItemStack.field_190927_a;
    private float energy;
    Random rand = new Random();
    EntityLivingBase entity;
    private int collectionLimit;
    private int coolDown;
    private boolean isDirty;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagCompound nbtItem = nbttagcompound.func_74775_l("Item");
        this.item = new ItemStack(nbtItem);
        this.energy = nbttagcompound.func_74760_g("PotEnergy");
        this.collectionLimit = nbttagcompound.func_74762_e("CollectionLimit");
        this.coolDown = nbttagcompound.func_74762_e("CoolDown");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        NBTTagCompound nbtItem = new NBTTagCompound();
        if (!this.item.func_190926_b()) {
            this.item.func_77955_b(nbtItem);
        }
        nbttagcompound.func_74782_a("Item", (NBTBase)nbtItem);
        nbttagcompound.func_74776_a("PotEnergy", this.energy);
        nbttagcompound.func_74768_a("CollectionLimit", this.collectionLimit);
        nbttagcompound.func_74768_a("CoolDown", this.coolDown);
        return nbttagcompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_73660_a() {
        if (this.isDirty) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
            this.isDirty = false;
        }
        if (this.isCoolingDown()) {
            --this.coolDown;
        }
        if (!this.item.func_190926_b() && this.item.func_77973_b() instanceof IEnergyContainerItem && !this.field_145850_b.field_72995_K && ((IEnergyContainerItem)this.item.func_77973_b()).canAcceptPE(this.item) && this.canTransferPE()) {
            ((IEnergyContainerItem)this.item.func_77973_b()).addEnergy(this.item, this.consumeEnergy(1.0f));
        }
        if (this.entity == null) {
            List mobs = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(8.0, 3.0, 8.0));
            for (EntityLivingBase mob : mobs) {
                if (mob instanceof EntityPlayer || mob instanceof EntityArmorStand || mob.func_70668_bt() == EnumCreatureAttribute.UNDEAD || mob.func_70668_bt() == AbyssalCraftAPI.SHADOW || !mob.func_70089_S() || mob.func_70631_g_()) continue;
                this.entity = mob;
                break;
            }
        }
        if (this.entity != null) {
            if (this.getContainedEnergy() < (float)this.getMaxEnergy()) {
                this.entity.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 20, 0, false, false));
            }
            if (!this.entity.func_70089_S()) {
                float num = this.entity.func_110138_aP();
                this.entity = null;
                if (!this.isCoolingDown() && this.getContainedEnergy() < (float)this.getMaxEnergy()) {
                    this.addEnergy(num);
                    this.collectionLimit = (int)((float)this.collectionLimit + num);
                }
            }
        }
        if (this.collectionLimit >= this.getMaxEnergy() / 5) {
            this.collectionLimit = 0;
            this.coolDown = 1200;
        }
        if (this.getContainedEnergy() > (float)this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    @Override
    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void setItem(ItemStack item) {
        this.item = item;
        this.isDirty = true;
    }

    public int getCooldownTimer() {
        return this.coolDown;
    }

    public boolean isCoolingDown() {
        return this.coolDown > 0;
    }

    @Override
    public float getContainedEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return 5000;
    }

    @Override
    public void addEnergy(float energy) {
        this.energy += energy;
        if (this.energy > (float)this.getMaxEnergy()) {
            this.energy = this.getMaxEnergy();
        }
    }

    @Override
    public float consumeEnergy(float energy) {
        if (energy < this.energy) {
            this.energy -= energy;
            return energy;
        }
        float ret = this.energy;
        this.energy = 0.0f;
        return ret;
    }

    @Override
    public boolean canAcceptPE() {
        return false;
    }

    @Override
    public boolean canTransferPE() {
        return this.getContainedEnergy() > 0.0f;
    }

    @Override
    public TileEntity getContainerTile() {
        return this;
    }
}

