/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.entity;

import com.shinoow.abyssalcraft.api.AbyssalCraftAPI;
import com.shinoow.abyssalcraft.api.entity.IAntiEntity;
import com.shinoow.abyssalcraft.api.entity.ICoraliumEntity;
import com.shinoow.abyssalcraft.api.entity.IDreadEntity;
import com.shinoow.abyssalcraft.api.entity.IOmotholEntity;
import com.shinoow.abyssalcraft.api.item.ACItems;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public final class EntityUtil {
    private static final List<Class<? extends EntityLivingBase>> shoggothFood = new ArrayList<Class<? extends EntityLivingBase>>();
    private static final List<String> dread_carriers = new ArrayList<String>();
    private static final List<String> dread_immunity = new ArrayList<String>();
    private static final List<String> coralium_carriers = new ArrayList<String>();
    private static final List<String> coralium_immunity = new ArrayList<String>();

    private EntityUtil() {
    }

    public static boolean isEntityCoralium(EntityLivingBase par1) {
        return par1 instanceof ICoraliumEntity || par1 instanceof IOmotholEntity || par1 instanceof EntityPlayer && EntityUtil.isPlayerCoralium((EntityPlayer)par1) || EntityList.func_191301_a((Entity)par1) != null && (coralium_immunity.contains(EntityList.func_191301_a((Entity)par1).toString()) || AbyssalCraftAPI.getInternalMethodHandler().isImmuneOrCarrier(EntityList.func_191301_a((Entity)par1).toString(), 2));
    }

    public static final boolean isPlayerCoralium(EntityPlayer par1) {
        if (Vars.dev) {
            return par1.func_70005_c_().equals("shinoow") || par1.func_70005_c_().equals("Oblivionaire");
        }
        return par1.func_110124_au().equals(Vars.uuid1) || par1.func_110124_au().equals(Vars.uuid2);
    }

    public static boolean isEntityDread(EntityLivingBase par1) {
        return par1 instanceof IDreadEntity || par1 instanceof IOmotholEntity || EntityList.func_191301_a((Entity)par1) != null && (dread_immunity.contains(EntityList.func_191301_a((Entity)par1).toString()) || AbyssalCraftAPI.getInternalMethodHandler().isImmuneOrCarrier(EntityList.func_191301_a((Entity)par1).toString(), 0));
    }

    public static boolean isEntityAnti(EntityLivingBase par1) {
        return par1 instanceof IAntiEntity || par1 instanceof IOmotholEntity;
    }

    public static boolean hasNecronomicon(EntityPlayer player) {
        return player.field_71071_by.func_70431_c(new ItemStack(ACItems.necronomicon)) || player.field_71071_by.func_70431_c(new ItemStack(ACItems.abyssal_wasteland_necronomicon)) || player.field_71071_by.func_70431_c(new ItemStack(ACItems.dreadlands_necronomicon)) || player.field_71071_by.func_70431_c(new ItemStack(ACItems.omothol_necronomicon)) || player.field_71071_by.func_70431_c(new ItemStack(ACItems.abyssalnomicon));
    }

    public static boolean isEntityImmune(EntityLivingBase entity, Potion potion) {
        return potion == AbyssalCraftAPI.coralium_plague && EntityUtil.isEntityCoralium(entity) || potion == AbyssalCraftAPI.dread_plague && EntityUtil.isEntityDread(entity) || potion == AbyssalCraftAPI.antimatter_potion && EntityUtil.isEntityAnti(entity);
    }

    public static void addShoggothFood(Class<? extends EntityLivingBase> clazz) {
        shoggothFood.add(clazz);
    }

    public static List<Class<? extends EntityLivingBase>> getShoggothFood() {
        return shoggothFood;
    }

    public static boolean isShoggothFood(EntityLivingBase entity) {
        for (Class<? extends EntityLivingBase> c : shoggothFood) {
            if (!c.isAssignableFrom(entity.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean canEntityBlockDamageSource(DamageSource damageSource, EntityLivingBase target) {
        Vec3d vec3d;
        if (!damageSource.func_76363_c() && target.func_184585_cz() && (vec3d = damageSource.func_188404_v()) != null) {
            Vec3d vec3d1 = target.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72444_a(new Vec3d(target.field_70165_t, target.field_70163_u, target.field_70161_v)).func_72432_b();
            vec3d2 = new Vec3d(vec3d2.field_72450_a, 0.0, vec3d2.field_72449_c);
            if (vec3d2.func_72430_b(vec3d1) < 0.0) {
                return true;
            }
        }
        return false;
    }

    public static boolean damageShield(EntityLivingBase entity, int amount) {
        ItemStack shield = entity.func_184607_cu();
        if (!shield.func_190926_b() && shield.func_77973_b().isShield(shield, entity)) {
            shield.func_77972_a(amount, entity);
            return true;
        }
        return false;
    }

    public static void addDreadPlagueImmunity(String entity) {
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            dread_immunity.add(entity);
        }
    }

    public static void addDreadPlagueCarrier(String entity) {
        EntityUtil.addDreadPlagueImmunity(entity);
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            dread_carriers.add(entity);
        }
    }

    public static void addCoraliumPlagueImmunity(String entity) {
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            coralium_immunity.add(entity);
        }
    }

    public static void addCoraliumPlagueCarrier(String entity) {
        EntityUtil.addCoraliumPlagueImmunity(entity);
        if (EntityList.func_180125_b((ResourceLocation)new ResourceLocation(entity))) {
            coralium_carriers.add(entity);
        }
    }

    public static boolean isDreadPlagueCarrier(EntityLivingBase entity) {
        return entity instanceof IDreadEntity || EntityList.func_191301_a((Entity)entity) != null && (dread_carriers.contains(EntityList.func_191301_a((Entity)entity).toString()) || AbyssalCraftAPI.getInternalMethodHandler().isImmuneOrCarrier(EntityList.func_191301_a((Entity)entity).toString(), 1));
    }

    public static boolean isCoraliumPlagueCarrier(EntityLivingBase entity) {
        return entity instanceof ICoraliumEntity || EntityList.func_191301_a((Entity)entity) != null && (coralium_carriers.contains(EntityList.func_191301_a((Entity)entity).toString()) || AbyssalCraftAPI.getInternalMethodHandler().isImmuneOrCarrier(EntityList.func_191301_a((Entity)entity).toString(), 3));
    }

    static class Vars {
        static boolean dev = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        static UUID uuid1 = UUID.fromString("a5d8abca-0979-4bb0-825a-f1ccda0b350b");
        static UUID uuid2 = UUID.fromString("08f3211c-d425-47fd-afd8-f0e7f94152c4");

        Vars() {
        }
    }
}

