/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.aenetvistool;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.util.AEPartLocation;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.aenetvistool.AENetVis;
import com.brandon3055.aenetvistool.client.gui.GuiNetVisualizer;
import com.brandon3055.aenetvistool.data.NetworkData;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class ItemNetVisualizer
extends ItemBCore {
    public ItemNetVisualizer() {
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ToolData toolData;
        TileEntity tile = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP && (toolData = ItemNetVisualizer.getToolData(stack)) != null) {
            IGridNode node = ItemNetVisualizer.resolveGridNode(tile);
            if (node != null) {
                toolData.setBoundPos(pos, world.field_73011_w.getDimension());
                ItemNetVisualizer.writeToolData(stack, toolData);
                IGrid grid = node.getGrid();
                NetworkData.scanNetwork(grid).sendToClient(player);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return tile instanceof IGridHost ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        if (player.func_70093_af()) {
            ItemStack stack = player.func_184586_b(handIn);
            ToolData toolData = ItemNetVisualizer.getToolData(stack);
            if (toolData != null) {
                toolData.setBoundPos(new BlockPos(0, -1, 0), 0);
                ItemNetVisualizer.writeToolData(stack, toolData);
            }
        } else if (worldIn.field_72995_K) {
            this.openGui(player, handIn);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    @SideOnly(value=Side.CLIENT)
    private void openGui(EntityPlayer player, EnumHand hand) {
        ToolData data = ItemNetVisualizer.getToolData(player.func_184586_b(hand));
        if (data != null) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiNetVisualizer(player, hand, data));
        }
    }

    private static void checkInitTool(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("uuid")) {
            String id = UUID.randomUUID().toString();
            ItemNBTHelper.setString((ItemStack)stack, (String)"uuid", (String)id);
            new ToolData(id).writeToNBT(stack.func_77978_p());
        }
    }

    public static String getToolId(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "";
        }
        ItemNetVisualizer.checkInitTool(stack);
        return ItemNBTHelper.getString((ItemStack)stack, (String)"uuid", (String)"");
    }

    public static boolean isValidTool(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == AENetVis.netVisualizer) {
            ItemNetVisualizer.checkInitTool(stack);
            return true;
        }
        return false;
    }

    @Nullable
    public static ToolData getToolData(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemNetVisualizer.checkInitTool(stack);
        if (ItemNetVisualizer.isValidTool(stack)) {
            ToolData config = new ToolData(ItemNetVisualizer.getToolId(stack));
            ItemNetVisualizer.loadDataFromStack(stack, config);
            return config;
        }
        return null;
    }

    public static ToolData loadDataFromStack(ItemStack stack, ToolData toolData) {
        if (stack.func_190926_b()) {
            return toolData;
        }
        ItemNetVisualizer.checkInitTool(stack);
        toolData.readFromNBT(stack.func_77978_p());
        return toolData;
    }

    public static void writeToolData(ItemStack stack, ToolData toolData) {
        if (stack.func_190926_b()) {
            return;
        }
        ItemNetVisualizer.checkInitTool(stack);
        toolData.writeToNBT(stack.func_77978_p());
    }

    private static IGridNode resolveGridNode(TileEntity tile) {
        if (tile instanceof IGridHost) {
            IGridHost host = (IGridHost)tile;
            IGridNode node = host.getGridNode(AEPartLocation.INTERNAL);
            if (node == null) {
                AEPartLocation local;
                AEPartLocation[] aEPartLocationArray = AEPartLocation.SIDE_LOCATIONS;
                int n = aEPartLocationArray.length;
                for (int i = 0; i < n && (node = host.getGridNode(local = aEPartLocationArray[i])) == null; ++i) {
                }
            }
            return node;
        }
        return null;
    }

    public static class ToolData {
        public final String id;
        public NetworkData.GridPos boundPos = new NetworkData.GridPos(new BlockPos(0, -1, 0), 0);
        public int cableNodeColour8 = 255;
        public int cableNodeColour32 = 65535;
        public int machineNodeColour8 = 0xFFFF00;
        public int machineNodeColour32 = 0x7FFF00;
        public int[] p2pColours = new int[]{0xBEBEFF, 0x404040, 0xFF0000, 65535, 0xFFAA00, 22527, 0xFFFF8C};
        public boolean randP2PColours = false;
        public boolean randP2PColourOffset = false;
        public boolean renderNoDepth = true;
        public boolean renderP2PNoDepth = true;
        public boolean enableP2P = true;
        public boolean enableChanelLabels = true;
        public boolean enableCableConnections = true;
        public boolean enableCableNodes = true;
        public boolean enableMachineNodes = true;
        public boolean highlightInactiveBuses = true;
        public boolean smallChannelLabels = false;

        public ToolData(String id) {
            this.id = id;
        }

        public void setBoundPos(BlockPos pos, int dimension) {
            this.boundPos = new NetworkData.GridPos(pos, dimension);
        }

        private void writeToNBT(NBTTagCompound compound) {
            compound.func_74772_a("bound_pos", this.boundPos.pos.func_177986_g());
            compound.func_74768_a("bound_dim", this.boundPos.dim);
            compound.func_74768_a("cable_node_colour_8", this.cableNodeColour8);
            compound.func_74768_a("cable_node_colour_32", this.cableNodeColour32);
            compound.func_74768_a("machine_node_colour_8", this.machineNodeColour8);
            compound.func_74768_a("machine_node_colour_32", this.machineNodeColour32);
            compound.func_74783_a("p2p_colours", this.p2pColours);
            compound.func_74757_a("rand_p2p_colours", this.randP2PColours);
            compound.func_74757_a("rand_p2p_colour_offset", this.randP2PColourOffset);
            compound.func_74757_a("render_no_depth", this.renderNoDepth);
            compound.func_74757_a("render_p2p_no_depth", this.renderP2PNoDepth);
            compound.func_74757_a("enable_p2p", this.enableP2P);
            compound.func_74757_a("enable_chanel_labels", this.enableChanelLabels);
            compound.func_74757_a("enable_cable_connections", this.enableCableConnections);
            compound.func_74757_a("enable_cable_nodes", this.enableCableNodes);
            compound.func_74757_a("enable_machine_nodes", this.enableMachineNodes);
            compound.func_74757_a("highlight_inactive_buses", this.highlightInactiveBuses);
            compound.func_74757_a("small_channel_labels", this.smallChannelLabels);
        }

        private void readFromNBT(NBTTagCompound compound) {
            this.boundPos = new NetworkData.GridPos(BlockPos.func_177969_a((long)compound.func_74763_f("bound_pos")), compound.func_74762_e("bound_dim"));
            this.cableNodeColour8 = compound.func_74762_e("cable_node_colour_8");
            this.cableNodeColour32 = compound.func_74762_e("cable_node_colour_32");
            this.machineNodeColour8 = compound.func_74762_e("machine_node_colour_8");
            this.machineNodeColour32 = compound.func_74762_e("machine_node_colour_32");
            this.p2pColours = compound.func_74759_k("p2p_colours");
            if (this.p2pColours.length != 7) {
                this.p2pColours = new int[]{0, 0, 0, 0, 0, 0, 0};
            }
            this.randP2PColours = compound.func_74767_n("rand_p2p_colours");
            this.randP2PColourOffset = compound.func_74767_n("rand_p2p_colour_offset");
            this.renderNoDepth = compound.func_74767_n("render_no_depth");
            this.renderP2PNoDepth = compound.func_74767_n("render_p2p_no_depth");
            this.enableP2P = compound.func_74767_n("enable_p2p");
            this.enableChanelLabels = compound.func_74767_n("enable_chanel_labels");
            this.enableCableConnections = compound.func_74767_n("enable_cable_connections");
            this.enableCableNodes = compound.func_74767_n("enable_cable_nodes");
            this.enableMachineNodes = compound.func_74767_n("enable_machine_nodes");
            this.highlightInactiveBuses = compound.func_74767_n("highlight_inactive_buses");
            this.smallChannelLabels = compound.func_74767_n("small_channel_labels");
        }

        public void toBytes(MCDataOutput output) {
            output.writeString(this.id);
            output.writeInt(this.cableNodeColour8);
            output.writeInt(this.cableNodeColour32);
            output.writeInt(this.machineNodeColour8);
            output.writeInt(this.machineNodeColour32);
            if (this.p2pColours.length != 7) {
                this.p2pColours = new int[]{0xBEBEFF, 0x404040, 0xFF0000, 65535, 0xFFAA00, 22527, 0xFFFF8C};
            }
            for (int i = 0; i < 7; ++i) {
                output.writeInt(this.p2pColours[i]);
            }
            output.writeBoolean(this.randP2PColours);
            output.writeBoolean(this.randP2PColourOffset);
            output.writeBoolean(this.renderNoDepth);
            output.writeBoolean(this.renderP2PNoDepth);
            output.writeBoolean(this.enableP2P);
            output.writeBoolean(this.enableChanelLabels);
            output.writeBoolean(this.enableCableConnections);
            output.writeBoolean(this.enableCableNodes);
            output.writeBoolean(this.enableMachineNodes);
            output.writeBoolean(this.highlightInactiveBuses);
            output.writeBoolean(this.smallChannelLabels);
        }

        public static void fromBytes(ToolData data, MCDataInput input) {
            data.cableNodeColour8 = input.readInt();
            data.cableNodeColour32 = input.readInt();
            data.machineNodeColour8 = input.readInt();
            data.machineNodeColour32 = input.readInt();
            data.p2pColours = new int[]{0, 0, 0, 0, 0, 0, 0};
            for (int i = 0; i < 7; ++i) {
                data.p2pColours[i] = input.readInt();
            }
            data.randP2PColours = input.readBoolean();
            data.randP2PColourOffset = input.readBoolean();
            data.renderNoDepth = input.readBoolean();
            data.renderP2PNoDepth = input.readBoolean();
            data.enableP2P = input.readBoolean();
            data.enableChanelLabels = input.readBoolean();
            data.enableCableConnections = input.readBoolean();
            data.enableCableNodes = input.readBoolean();
            data.enableMachineNodes = input.readBoolean();
            data.highlightInactiveBuses = input.readBoolean();
            data.smallChannelLabels = input.readBoolean();
        }

        public boolean isTargetValid(World worldRef) {
            return this.getGridNode(worldRef) != null;
        }

        @Nullable
        public IGridNode getGridNode(World worldRef) {
            World world = this.resolveBoundWorld(worldRef);
            if (world != null) {
                TileEntity tile = world.func_175625_s(this.boundPos.pos);
                return ItemNetVisualizer.resolveGridNode(tile);
            }
            return null;
        }

        private World resolveBoundWorld(World worldRef) {
            if (worldRef.field_72995_K || this.boundPos == null) {
                return null;
            }
            MinecraftServer server = worldRef.func_73046_m();
            if (server == null || !DimensionManager.isDimensionRegistered((int)this.boundPos.dim)) {
                return null;
            }
            return server.func_71218_a(this.boundPos.dim);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ToolData)) {
                return false;
            }
            ToolData other = (ToolData)obj;
            if (this.cableNodeColour8 != other.cableNodeColour8) {
                return false;
            }
            if (this.cableNodeColour32 != other.cableNodeColour32) {
                return false;
            }
            if (this.machineNodeColour8 != other.machineNodeColour8) {
                return false;
            }
            if (this.machineNodeColour32 != other.machineNodeColour32) {
                return false;
            }
            if (this.randP2PColours != other.randP2PColours) {
                return false;
            }
            if (this.randP2PColourOffset != other.randP2PColourOffset) {
                return false;
            }
            if (this.renderNoDepth != other.renderNoDepth) {
                return false;
            }
            if (this.renderP2PNoDepth != other.renderP2PNoDepth) {
                return false;
            }
            if (this.enableP2P != other.enableP2P) {
                return false;
            }
            if (this.enableChanelLabels != other.enableChanelLabels) {
                return false;
            }
            if (this.enableCableConnections != other.enableCableConnections) {
                return false;
            }
            if (this.enableCableNodes != other.enableCableNodes) {
                return false;
            }
            if (this.enableMachineNodes != other.enableMachineNodes) {
                return false;
            }
            if (this.highlightInactiveBuses != other.highlightInactiveBuses) {
                return false;
            }
            if (this.smallChannelLabels != other.smallChannelLabels) {
                return false;
            }
            return ArrayUtils.isEquals((Object)this.p2pColours, (Object)other.p2pColours);
        }
    }
}

