/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.vitalize.api;

import earth.terrarium.vitalize.api.ModifiedLootContext;
import earth.terrarium.vitalize.api.PylonType;
import earth.terrarium.vitalize.blocks.SoulRevitalizerBlockEntity;
import earth.terrarium.vitalize.recipes.BeheadingData;
import earth.terrarium.vitalize.registry.VitalizeItems;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import me.codexadrian.spirit.entity.EntityRarity;
import me.codexadrian.spirit.utils.SoulUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DefaultPylonType implements PylonType
{
    BEHEADING(3, 1.45){

        @Override
        public ObjectArrayList<ItemStack> modifyLootTable(ObjectArrayList<ItemStack> lootTable, ServerLevel serverLevel, EntityType<?> entity) {
            ItemStack head = BeheadingData.getHead(serverLevel, entity);
            if (!head.m_41619_() && serverLevel.f_46441_.m_188501_() < 0.05f) {
                lootTable.add((Object)head);
            }
            return lootTable;
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237110_((String)("block.vitalize." + this.name + ".info"), (Object[])new Object[]{5}));
        }
    }
    ,
    EXPERIENCE(3, 1.25){

        @Override
        public ObjectArrayList<ItemStack> modifyLootTable(ObjectArrayList<ItemStack> lootTable, ServerLevel serverLevel, EntityType<?> entity) {
            EntityRarity rarity = EntityRarity.getRarity(entity);
            if ((double)serverLevel.f_46441_.m_188501_() < 0.05) {
                lootTable.add((Object)new ItemStack((ItemLike)VitalizeItems.EXPERIENCE_CUBED.get(), rarity.experienceDrops < 2 ? 1 : serverLevel.f_46441_.m_216339_(rarity.experienceDrops / 2, rarity.experienceDrops)));
            }
            return lootTable;
        }

        @Override
        public void onEnd(ObjectArrayList<ItemStack> drops, SoulRevitalizerBlockEntity core) {
            for (int i = 0; i < drops.size(); ++i) {
                ItemStack itemStack = (ItemStack)drops.get(i);
                if (itemStack.m_150930_(VitalizeItems.EXPERIENCE_SQUARED.get())) {
                    drops.set(i, (Object)new ItemStack((ItemLike)VitalizeItems.EXPERIENCE_CUBED.get(), itemStack.m_41613_()));
                    continue;
                }
                if (!itemStack.m_150930_(VitalizeItems.EXPERIENCE.get())) continue;
                drops.set(i, (Object)new ItemStack((ItemLike)VitalizeItems.EXPERIENCE_SQUARED.get(), itemStack.m_41613_()));
            }
            super.onEnd(drops, core);
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237115_((String)("block.vitalize." + this.name + ".info_one")), Component.m_237110_((String)("block.vitalize." + this.name + ".info_two"), (Object[])new Object[]{5}), Component.m_237115_((String)("block.vitalize." + this.name + ".info_three")));
        }
    }
    ,
    FLAME(1, 1.075){

        @Override
        public ModifiedLootContext modifyLootContext(ModifiedLootContext context) {
            context.getEntity().m_20254_(10);
            return context;
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237115_((String)("block.vitalize." + this.name + ".info")));
        }
    }
    ,
    LOOTING(3, 1.25){

        @Override
        public ModifiedLootContext modifyLootContext(ModifiedLootContext context) {
            context.incrementLootingAmount();
            return super.modifyLootContext(context);
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237110_((String)("block.vitalize." + this.name + ".info"), (Object[])new Object[]{1}));
        }
    }
    ,
    RECURSIVE(1, 1.5){

        @Override
        public void onEnd(ObjectArrayList<ItemStack> drops, SoulRevitalizerBlockEntity core) {
            if (core.m_58904_() != null && (double)core.m_58904_().f_46441_.m_188501_() < 0.15) {
                SoulUtils.deviateSoulCount((ItemStack)core.getCrystal(), (int)1, (Level)core.m_58904_(), null);
            }
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237110_((String)("block.vitalize." + this.name + ".info_one"), (Object[])new Object[]{15}), Component.m_237110_((String)("block.vitalize." + this.name + ".info_two"), (Object[])new Object[]{1}));
        }
    }
    ,
    SPEED(5, 1.25){

        @Override
        public void onStart(SoulRevitalizerBlockEntity core) {
            core.setMaxTickTime((int)Math.max(1.0, (double)core.getMaxTickTime() * 0.85));
            super.onStart(core);
        }

        @Override
        public List<Component> description() {
            return List.of(Component.m_237110_((String)("block.vitalize." + this.name + ".info"), (Object[])new Object[]{15}));
        }
    }
    ,
    EFFICIENCY(5, 0.85){

        @Override
        public List<Component> description() {
            return List.of();
        }
    }
    ,
    BASE(8, 1.0){

        @Override
        public List<Component> description() {
            return List.of();
        }
    };

    private final int maxLevel;
    private final double energyModifier;
    public final String name;

    private DefaultPylonType(int maxLevel, double energyModifier) {
        this.maxLevel = maxLevel;
        this.energyModifier = energyModifier;
        this.name = "pylon_" + this.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("vitalize", this.name().toLowerCase(Locale.ROOT));
    }

    @Override
    public int maxLevel() {
        return this.maxLevel;
    }

    @Override
    public double energyModifier() {
        return this.energyModifier;
    }
}

