/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.util;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import twilightforest.init.TFBlocks;
import twilightforest.util.FeatureLogic;
import twilightforest.util.VoxelBresenhamIterator;

public final class FeaturePlacers {
    public static final BiFunction<LevelSimulatedReader, BlockPos, Boolean> VALID_TREE_POS = TreeFeature::m_67272_;

    public static <T extends Mob> void placeEntity(EntityType<T> entityType, BlockPos pos, ServerLevelAccessor levelAccessor) {
        Mob mob = (Mob)entityType.m_20615_((Level)levelAccessor.m_6018_());
        if (mob == null) {
            return;
        }
        mob.m_21530_();
        mob.m_20035_(pos, 0.0f, 0.0f);
        mob.m_6518_(levelAccessor, levelAccessor.m_6436_(pos), MobSpawnType.STRUCTURE, null, null);
        levelAccessor.m_47205_((Entity)mob);
        levelAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public static void drawBresenhamBranch(LevelAccessor world, BiConsumer<BlockPos, BlockState> trunkPlacer, RandomSource random, BlockPos start, BlockPos end, BlockStateProvider config) {
        for (BlockPos pixel : new VoxelBresenhamIterator(start, end)) {
            FeaturePlacers.placeIfValidTreePos((LevelSimulatedReader)world, trunkPlacer, random, pixel, config);
        }
    }

    public static void buildRoot(LevelAccessor world, BiConsumer<BlockPos, BlockState> placer, RandomSource rand, BlockPos start, double offset, int b, BlockStateProvider config) {
        BlockPos dest = FeatureLogic.translate(start.m_6625_(b + 2), 5.0, 0.3 * (double)b + offset, 0.8);
        for (BlockPos coord : new VoxelBresenhamIterator(start.m_7495_(), dest)) {
            if (FeaturePlacers.placeIfValidRootPos((LevelSimulatedReader)world, placer, rand, coord, config)) continue;
            return;
        }
    }

    public static void drawBresenhamTree(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos from, BlockPos to, BlockStateProvider config, RandomSource random) {
        for (BlockPos pixel : new VoxelBresenhamIterator(from, to)) {
            FeaturePlacers.placeProvidedBlock(world, placer, predicate, pixel, config, random);
        }
    }

    public static void placeProvidedBlock(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> worldPlacer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, BlockPos pos, BlockStateProvider config, RandomSource random) {
        if (predicate.apply(world, pos).booleanValue()) {
            worldPlacer.accept(pos, config.m_213972_(random, pos));
        }
    }

    public static void placeCircleOdd(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        float radiusSquared = radius * radius;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 1;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeCircleEven(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float radius, BlockStateProvider config) {
        float radiusSquared = radius * radius;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int x = 0;
        while ((float)x <= radius) {
            int z = 0;
            while ((float)z <= radius) {
                if ((float)(x * x + z * z) <= radiusSquared) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(1 + x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, 1 + z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(1 + x, 0, -z), config, random);
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, float verticalBias, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + ((float)y2 - verticalBias) * ((float)y2 - verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, y2, -x), config, random);
                        }
                        if (xzSquare + ((float)y2 + verticalBias) * ((float)y2 + verticalBias) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, -y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, -y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, -y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static void placeSpheroid(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, BiFunction<LevelSimulatedReader, BlockPos, Boolean> predicate, RandomSource random, BlockPos centerPos, float xzRadius, float yRadius, BlockStateProvider config) {
        float xzRadiusSquared = xzRadius * xzRadius;
        float yRadiusSquared = yRadius * yRadius;
        float superRadiusSquared = xzRadiusSquared * yRadiusSquared;
        FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos, config, random);
        int y = 0;
        while ((float)y <= yRadius) {
            if (!((float)y > yRadius)) {
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, y, 0), config, random);
                FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(0, -y, 0), config, random);
            }
            ++y;
        }
        int x = 0;
        while ((float)x <= xzRadius) {
            int z = 1;
            while ((float)z <= xzRadius) {
                if (!((float)(x * x + z * z) > xzRadiusSquared)) {
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, 0, z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, 0, -z), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, 0, x), config, random);
                    FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, 0, -x), config, random);
                    int y2 = 1;
                    while ((float)y2 <= yRadius) {
                        float xzSquare = (float)(x * x + z * z) * yRadiusSquared;
                        if (xzSquare + (float)(y2 * y2) * xzRadiusSquared <= superRadiusSquared) {
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, y2, -x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(x, -y2, z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-x, -y2, -z), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(-z, -y2, x), config, random);
                            FeaturePlacers.placeProvidedBlock(world, placer, predicate, centerPos.m_7918_(z, -y2, -x), config, random);
                        }
                        ++y2;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    public static boolean placeIfValidTreePos(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (TreeFeature.m_67272_((LevelSimulatedReader)world, (BlockPos)pos)) {
            placer.accept(pos, config.m_213972_(random, pos));
            return true;
        }
        return false;
    }

    public static boolean placeIfValidRootPos(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> placer, RandomSource random, BlockPos pos, BlockStateProvider config) {
        if (FeatureLogic.canRootGrowIn(world, pos)) {
            placer.accept(pos, config.m_213972_(random, pos));
            return true;
        }
        return false;
    }

    public static void addFirefly(LevelAccessor world, BlockPos pos, int height, double angle) {
        int iAngle = (int)(angle * 4.0);
        if (iAngle == 0) {
            FeaturePlacers.setIfEmpty(world, pos.m_7918_(1, height, 0), (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.EAST));
        } else if (iAngle == 1) {
            FeaturePlacers.setIfEmpty(world, pos.m_7918_(-1, height, 0), (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.WEST));
        } else if (iAngle == 2) {
            FeaturePlacers.setIfEmpty(world, pos.m_7918_(0, height, 1), (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.SOUTH));
        } else if (iAngle == 3) {
            FeaturePlacers.setIfEmpty(world, pos.m_7918_(0, height, -1), (BlockState)((Block)TFBlocks.FIREFLY.get()).m_49966_().m_61124_((Property)DirectionalBlock.f_52588_, (Comparable)Direction.NORTH));
        }
    }

    private static void setIfEmpty(LevelAccessor world, BlockPos pos, BlockState state) {
        if (world.m_46859_(pos)) {
            world.m_7731_(pos, state, 3);
        }
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, Block blockOut) {
        return FeaturePlacers.transferAllStateKeys(stateIn, blockOut.m_49966_());
    }

    public static BlockState transferAllStateKeys(BlockState stateIn, BlockState stateOut) {
        for (Property property : stateOut.m_61147_()) {
            stateOut = FeaturePlacers.transferStateKey(stateIn, stateOut, property);
        }
        return stateOut;
    }

    public static <T extends Comparable<T>> BlockState transferStateKey(BlockState stateIn, BlockState stateOut, Property<T> property) {
        if (!stateIn.m_61138_(property) || !stateOut.m_61138_(property)) {
            return stateOut;
        }
        return (BlockState)stateOut.m_61124_(property, stateIn.m_61143_(property));
    }

    public static void traceRoot(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, RandomSource random, BlockStateProvider dirtRoot, Iterable<BlockPos> posTracer) {
        for (BlockPos rootPos : posTracer) {
            if (worldReader.m_7433_(rootPos, FeatureLogic.ROOT_SHOULD_SKIP) || FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, rootPos, dirtRoot)) continue;
            return;
        }
    }

    public static void traceExposedRoot(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, RandomSource random, BlockStateProvider exposedRoot, BlockStateProvider dirtRoot, Iterable<BlockPos> posTracer) {
        for (BlockPos exposedPos : posTracer) {
            if (worldReader.m_7433_(exposedPos, FeatureLogic.ROOT_SHOULD_SKIP)) continue;
            if (!FeatureLogic.hasEmptyHorizontalNeighbor(worldReader, exposedPos)) {
                if (FeaturePlacers.placeIfValidRootPos(worldReader, worldPlacer, random, exposedPos, dirtRoot)) {
                    FeaturePlacers.traceRoot(worldReader, worldPlacer, random, dirtRoot, posTracer);
                }
                return;
            }
            if (!worldReader.m_7433_(exposedPos, FeatureLogic::worldGenReplaceable)) {
                return;
            }
            worldPlacer.accept(exposedPos, exposedRoot.m_213972_(random, exposedPos));
        }
    }
}

