/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RenderBlockScreenEffectEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.api.capability.ITBCapability;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.enchantment.TombstoneEnchantment;
import ovh.corail.tombstone.gui.CompendiumData;
import ovh.corail.tombstone.gui.ScreenCompendium;
import ovh.corail.tombstone.gui.ScreenConfig;
import ovh.corail.tombstone.gui.ScreenKnowledge;
import ovh.corail.tombstone.gui.TBScreen;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.FontHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.MarkerHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageResetPerk;
import ovh.corail.tombstone.particle.ParticleGhost;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEffects;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ClientEventHandler {
    public static final KeyMapping KEYBIND_KNOWLEDGE = new KeyMapping(LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    public static final KeyMapping KEYBIND_CONFIG = new KeyMapping(LangKey.MESSAGE_CONFIG.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    public static final KeyMapping KEYBIND_COMPENDIUM = new KeyMapping(LangKey.MESSAGE_COMPENDIUM.getKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "Corail Tombstone");
    private static OpeningGui openingGui = OpeningGui.NONE;
    private static CompendiumData.CompendiumLabel compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
    private static boolean isFirstGuiGameOver = false;
    public static boolean hasTrueSight = false;
    public static boolean hasWaterVision = false;
    private static long nextGhostTime = -1L;
    public static String toDisplay;
    private static int earnedLevel;
    private static int displayLeftTime;
    private static final SuggestionProvider<CommandSourceStack> LABEL_SUGGESTION;
    private static long LAST_PACKET;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        if (mc.f_91074_ == null || mc.f_91073_ == null) {
            hasWaterVision = false;
            hasTrueSight = false;
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            hasTrueSight = EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.ghostly_shape) || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.true_sight);
            hasWaterVision = hasTrueSight || EffectHelper.isPotionActive((LivingEntity)mc.f_91074_, ModEffects.aquatic_life);
            toDisplay = null;
            if (displayLeftTime > 0 && --displayLeftTime == 0) {
                LangKey.MESSAGE_ACCESS_GUI.sendSpecialMessage((Player)mc.f_91074_, earnedLevel, LangKey.MESSAGE_HERE.createComponentCommand("/tbgui", new Object[0]));
                earnedLevel = 0;
            }
            MarkerHandler.instance.update(mc);
        } else {
            TBScreen screen;
            switch (openingGui) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case KNOWLEDGE: {
                    TBScreen tBScreen = mc.f_91074_.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(cap -> new ScreenKnowledge(mc.f_91074_, (ITBCapability)cap)).orElse(null);
                    break;
                }
                case CONFIG: {
                    TBScreen tBScreen = new ScreenConfig();
                    break;
                }
                case COMPENDIUM: {
                    TBScreen tBScreen = new ScreenCompendium(compendiumLabel);
                    break;
                }
                case NONE: {
                    TBScreen tBScreen = screen = null;
                }
            }
            if (screen == null) {
                if (mc.f_91080_ == null || mc.f_91080_ instanceof ChatScreen) {
                    if (KEYBIND_COMPENDIUM.m_90859_()) {
                        openingGui = OpeningGui.COMPENDIUM;
                    } else if (KEYBIND_CONFIG.m_90859_()) {
                        openingGui = OpeningGui.CONFIG;
                    } else if (KEYBIND_KNOWLEDGE.m_90859_()) {
                        openingGui = OpeningGui.KNOWLEDGE;
                    }
                }
            } else {
                openingGui = OpeningGui.NONE;
                mc.m_91152_((Screen)screen);
            }
            if (((Boolean)ConfigTombstone.client.allowHalloweenGhost.get()).booleanValue() && TimeHelper.isDateAroundHalloween()) {
                if (Helper.isNight((Level)mc.f_91073_)) {
                    long time = TimeHelper.worldTicks((Level)mc.f_91073_);
                    if (nextGhostTime == -1L || time > nextGhostTime) {
                        if (nextGhostTime > -1L && CooldownHandler.INSTANCE.noCooldown((Player)mc.f_91074_, CooldownType.NEXT_PRAY)) {
                            Vec3 ghostVec = mc.f_91074_.m_20182_().m_82520_((Helper.RANDOM.nextDouble() - 0.5) * 18.0, 0.0, (Helper.RANDOM.nextDouble() - 0.5) * 18.0);
                            mc.f_91061_.m_107344_((Particle)new ParticleGhost(mc.f_91073_, ghostVec.f_82479_, ghostVec.f_82480_, ghostVec.f_82481_, 0.0, 0.0));
                        }
                        nextGhostTime = time + (long)Helper.RANDOM.nextInt(6000) + 60L;
                    }
                } else {
                    nextGhostTime = -1L;
                }
            }
        }
    }

    @SubscribeEvent
    public static void onRegisterCommand(RegisterClientCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"tbgui").executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE))).then(OpeningGui.KNOWLEDGE.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.KNOWLEDGE)))).then(OpeningGui.CONFIG.literal().executes(c -> ClientEventHandler.openingGui(OpeningGui.CONFIG)))).then(((LiteralArgumentBuilder)OpeningGui.COMPENDIUM.literal().executes(c -> ClientEventHandler.openingCompendium())).then(Commands.m_82129_((String)"label", (ArgumentType)StringArgumentType.word()).suggests(LABEL_SUGGESTION).executes(c -> ClientEventHandler.openingCompendium(StringArgumentType.getString((CommandContext)c, (String)"label"))))));
    }

    private static int openingGui(OpeningGui gui) {
        openingGui = gui;
        compendiumLabel = CompendiumData.CompendiumLabel.COMPENDIUM;
        return 1;
    }

    private static int openingCompendium() {
        return ClientEventHandler.openingGui(OpeningGui.COMPENDIUM);
    }

    private static int openingCompendium(String labelString) {
        CompendiumData.CompendiumLabel label = CompendiumData.CompendiumLabel.fromString(labelString);
        if (label == null) {
            throw LangKey.MESSAGE_INVALID_LABEL.asCommandException(new Object[0]);
        }
        openingGui = OpeningGui.COMPENDIUM;
        compendiumLabel = label;
        return 1;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onGuiOpened(ScreenEvent.Opening event) {
        LocalPlayer player;
        if (event.getScreen() instanceof DeathScreen && ((Boolean)ConfigTombstone.client.skipRespawnScreen.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && !player.f_19853_.m_6106_().m_5466_()) {
            isFirstGuiGameOver = !isFirstGuiGameOver;
            event.setCanceled(true);
            if (!isFirstGuiGameOver) {
                player.m_7583_();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onFogDensity(ViewportEvent.RenderFog event) {
        FluidState fluidState;
        boolean isWater;
        if (hasWaterVision && ((isWater = (fluidState = event.getCamera().getBlockAtCamera().m_60819_()).m_205070_(FluidTags.f_13131_)) || hasTrueSight && fluidState.m_205070_(FluidTags.f_13132_))) {
            event.setCanceled(true);
            event.setFarPlaneDistance(192.0f * (isWater ? 1.0f : 0.09375f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderFogHigh(ViewportEvent.ComputeFogColor event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && hasTrueSight && !player.m_21023_(MobEffects.f_19611_) && !player.m_21023_(MobEffects.f_216964_) && event.getRed() != 0.0f && event.getGreen() != 0.0f && event.getBlue() != 0.0f) {
            float f9 = Math.min(1.0f / event.getRed(), Math.min(1.0f / event.getGreen(), 1.0f / event.getBlue()));
            float f7 = GameRenderer.m_109108_((LivingEntity)player, (float)Minecraft.m_91087_().getPartialTick());
            event.setRed(event.getRed() * (1.0f - f7) + event.getRed() * f9 * f7);
            event.setGreen(event.getGreen() * (1.0f - f7) + event.getGreen() * f9 * f7);
            event.setBlue(event.getBlue() * (1.0f - f7) + event.getBlue() * f9 * f7);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderFogLow(ViewportEvent.ComputeFogColor event) {
        if (hasWaterVision) {
            FluidState fluidState = event.getCamera().getBlockAtCamera().m_60819_();
            if (fluidState.m_205070_(FluidTags.f_13131_)) {
                event.setRed(0.09f);
                event.setGreen(0.42f);
                event.setBlue(0.93f);
            } else if (fluidState.m_205070_(FluidTags.f_13132_) && hasTrueSight) {
                event.setRed(1.0f);
                event.setGreen(0.32f);
                event.setBlue(0.09f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRenderBlockLayer(RenderBlockScreenEffectEvent event) {
        if (hasWaterVision && (event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.WATER || event.getOverlayType() == RenderBlockScreenEffectEvent.OverlayType.FIRE && hasTrueSight)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleTooltip(ItemTooltipEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (event.getItemStack().m_150930_(Items.f_151058_)) {
            boolean isEnchanted = event.getItemStack().getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).map(stack -> stack.isEnchanted(event.getItemStack())).orElse(false);
            if (isEnchanted) {
                event.getToolTip().add(ModEnchantments.soulbound.m_44700_(1));
            } else {
                event.getToolTip().add(1, Component.m_237115_((String)"tombstone.item.enchanted_bundle.desc").m_6270_(StyleType.TOOLTIP_USE));
            }
        }
        if (!SupportMods.ENCH_DESC.isLoaded() && ((Boolean)ConfigTombstone.client.showInfoOnEnchantment.get()).booleanValue() && event.getItemStack().m_41782_()) {
            boolean isEnchantedBook = event.getItemStack().m_150930_(Items.f_42690_);
            if (!isEnchantedBook && ModEnchantments.getEnchantments().values().stream().allMatch(TombstoneEnchantment::isEnabled)) {
                return;
            }
            ListTag taglist = isEnchantedBook ? EnchantedBookItem.m_41163_((ItemStack)event.getItemStack()) : event.getItemStack().m_41785_();
            List<TombstoneEnchantment> list = IntStream.range(0, taglist.size()).mapToObj(arg_0 -> ((ListTag)taglist).m_128728_(arg_0)).map(nbt -> nbt.m_128461_("id")).filter(id -> !id.isEmpty() && ModEnchantments.getEnchantments().containsKey(id)).map(ModEnchantments.getEnchantments()::get).toList();
            for (TombstoneEnchantment enchant : list) {
                IntStream.range(0, event.getToolTip().size()).filter(line -> {
                    Component currentTooltip = (Component)event.getToolTip().get(line);
                    ComponentContents patt15481$temp = currentTooltip.m_214077_();
                    if (!(patt15481$temp instanceof TranslatableContents)) return false;
                    TranslatableContents contents = (TranslatableContents)patt15481$temp;
                    if (!enchant.m_44704_().equals(contents.m_237508_())) return false;
                    return true;
                }).findFirst().ifPresent(line -> {
                    List<Component> infos = enchant.getTooltipInfos(isEnchantedBook);
                    for (Component info : infos) {
                        event.getToolTip().add(++line, info);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                MarkerHandler.instance.renderBox(event.getPoseStack());
            }
        }
    }

    @SubscribeEvent
    public static void renderScreenMessage(TickEvent.RenderTickEvent event) {
        int minY;
        int halfWidth;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            toDisplay = null;
            earnedLevel = 0;
            displayLeftTime = 0;
            return;
        }
        if (mc.f_91080_ != null || mc.m_91104_()) {
            return;
        }
        if (toDisplay != null) {
            halfWidth = mc.m_91268_().m_85445_() / 2;
            minY = 50;
            int halfLength = mc.f_91062_.m_92895_(toDisplay) / 2;
            PoseStack poseStack = new PoseStack();
            Objects.requireNonNull(mc.f_91062_);
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(halfWidth - halfLength - 2), (int)(minY - 2), (int)(halfWidth + halfLength + 2), (int)(minY + 9 + 1), (int)Integer.MIN_VALUE);
            FontHelper.drawCenteredFantasy(poseStack, mc.f_91062_, (Component)Component.m_237113_((String)toDisplay), halfWidth, minY, -8347488);
        }
        if (earnedLevel > 0) {
            halfWidth = mc.m_91268_().m_85445_() / 2;
            minY = mc.m_91268_().m_85446_() / 2;
            int newLevel = Optional.ofNullable(mc.f_91074_).map(p -> p.getCapability(TBCapabilityProvider.TB_CAPABILITY).map(ITBCapability::getTotalPerkPoints).orElse(0)).orElse(0);
            Component message = FontHelper.withFantasyFont((Component)LangKey.MESSAGE_KNOWLEDGE_OF_DEATH.getText(new Object[0]).m_7220_((Component)Component.m_237113_((String)(": " + Helper.getRomanNumber(newLevel - earnedLevel) + " -> " + Helper.getRomanNumber(newLevel)))));
            int halfLength = mc.f_91062_.m_92852_((FormattedText)message) / 2 + 14;
            int halfHeight = 10;
            int a = 255;
            int c = 0;
            if (displayLeftTime >= 90) {
                ratio = TimeHelper.rise(100 - displayLeftTime, 10);
                a = (int)(ratio * 255.0f);
                halfLength = (int)((float)halfLength * ratio);
                halfHeight = (int)((float)halfHeight * ratio);
            } else if (displayLeftTime >= 85) {
                ratio = TimeHelper.flicker(89 - displayLeftTime, 5);
                c = (int)(255.0f * ratio);
            } else if (displayLeftTime <= 11) {
                ratio = TimeHelper.downfall(11 - displayLeftTime, 10);
                a = (int)(ratio * 255.0f);
                halfLength = (int)((float)halfLength * ratio);
                halfHeight = (int)((float)halfHeight * ratio);
            } else if (displayLeftTime <= 16) {
                ratio = TimeHelper.flicker(16 - displayLeftTime, 5);
                c = (int)(255.0f * ratio);
            }
            PoseStack poseStack = new PoseStack();
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(halfWidth - halfLength - 2), (int)(minY - halfHeight - 2), (int)(halfWidth + halfLength + 2), (int)(minY + halfHeight + 2), (int)(a << 24 | 0xFACA78));
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(halfWidth - halfLength), (int)(minY - halfHeight), (int)(halfWidth + halfLength), (int)(minY + halfHeight), (int)(a << 24 | c << 16 | c << 8 | c));
            if (displayLeftTime > 16 && displayLeftTime < 85) {
                int iconHeight = halfHeight * 2;
                int textAlpha = (int)(TimeHelper.flicker(displayLeftTime - 16, 69) * 255.0f);
                Font font = mc.f_91062_;
                float f = (float)halfWidth + (float)iconHeight / 2.0f + 2.0f;
                float f2 = (float)minY + 1.0f;
                Objects.requireNonNull(mc.f_91062_);
                FontHelper.drawCentered(poseStack, font, message, f, f2 - 9.0f / 2.0f, Mth.m_14045_((int)textAlpha, (int)4, (int)255) << 24 | 0xFACA78);
                RenderSystem.m_157456_((int)0, (ResourceLocation)TBScreen.FRAME);
                RenderSystem.m_157429_((float)((float)textAlpha / 255.0f), (float)1.0f, (float)1.0f, (float)1.0f);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(halfWidth - halfLength), (int)(minY - halfHeight), (float)0.0f, (float)0.0f, (int)iconHeight, (int)iconHeight, (int)iconHeight, (int)iconHeight);
                mc.m_91291_().m_115203_(new ItemStack((ItemLike)ModItems.ankh_of_pray), halfWidth - halfLength + 1, minY - 8);
            }
        }
    }

    public static void showEarnedLevel(int earned) {
        earnedLevel += earned;
        if (displayLeftTime <= 0) {
            displayLeftTime = 100;
        } else if (displayLeftTime < 84) {
            displayLeftTime = 84;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onFieldOfView(ComputeFovModifierEvent event) {
        if (!event.getPlayer().m_6117_() && event.getPlayer().m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.christmas_hat) && event.getPlayer().m_150110_().m_35947_() != 0.0f) {
            event.setNewFovModifier(event.getNewFovModifier() - 0.25f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onClickAttack(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isAttack() && event.getHand() == InteractionHand.MAIN_HAND) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ != null && mc.f_91074_ != null && mc.f_91074_.m_21205_().m_150930_((Item)ModItems.ankh_of_pray)) {
                BlockState state;
                BlockHitResult result;
                event.setCanceled(true);
                if (mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (result = (BlockHitResult)mc.f_91077_).m_82448_((Entity)mc.f_91074_) < 25.0 && ModBlocks.DECORATIVE_GRAVES.containsValue((state = mc.f_91073_.m_8055_(result.m_82425_())).m_60734_()) && mc.f_91073_.m_46467_() >= LAST_PACKET + 20L) {
                    LAST_PACKET = mc.f_91073_.m_46467_();
                    PacketHandler.sendToServer(new SMessageResetPerk(result.m_82450_(), result.m_82434_(), result.m_82425_(), result.m_82436_()));
                    mc.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                }
                event.setSwingHand(false);
            }
        }
    }

    static {
        earnedLevel = 0;
        displayLeftTime = 0;
        LABEL_SUGGESTION = (ctx, build) -> SharedSuggestionProvider.m_82981_(Arrays.stream(CompendiumData.CompendiumLabel.values()).map(Enum::name).map(s -> s.toLowerCase(Locale.US)), (SuggestionsBuilder)build);
        LAST_PACKET = 0L;
    }

    private static enum OpeningGui implements ISubCommand
    {
        NONE,
        KNOWLEDGE,
        CONFIG,
        COMPENDIUM;

    }
}

