/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen.addon;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonAddon;
import com.hrznstudio.titanium.client.screen.addon.StateButtonInfo;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.button.ButtonComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponentHarness;
import com.hrznstudio.titanium.component.sideness.SidedComponentManager;
import com.hrznstudio.titanium.container.IDisableableContainer;
import com.hrznstudio.titanium.container.IObjectContainer;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.AssetUtil;
import com.hrznstudio.titanium.util.FacingUtil;
import com.hrznstudio.titanium.util.LangUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FacingHandlerScreenAddon
extends BasicScreenAddon {
    private final IFacingComponent handler;
    private List<StateButtonAddon> buttonAddons;
    private int xSize;
    private int ySize;
    private boolean clicked;
    private Point inventoryPoint;
    private IAssetType<?> assetType;
    private Direction blockDirection;

    public FacingHandlerScreenAddon(SidedComponentManager manager, IFacingComponent facingHandler, IAssetType<?> assetType, Direction blockDirection) {
        super(manager.getPosX(), manager.getPosY());
        this.handler = facingHandler;
        this.buttonAddons = new ArrayList<StateButtonAddon>();
        this.xSize = 0;
        this.ySize = 0;
        this.clicked = false;
        this.assetType = assetType;
        this.blockDirection = blockDirection;
    }

    public static Point getPointFromFacing(FacingUtil.Sideness sideness, Point inventory) {
        Point origin = new Point(inventory.x + 73, inventory.y + 19);
        switch (sideness) {
            case TOP: {
                origin.translate(0, -16);
                break;
            }
            case BOTTOM: {
                origin.translate(0, 16);
                break;
            }
            case LEFT: {
                origin.translate(-16, 0);
                break;
            }
            case RIGHT: {
                origin.translate(16, 0);
                break;
            }
            case BACK: {
                origin.translate(16, 16);
            }
        }
        return origin;
    }

    @Override
    public void drawBackgroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        IBackgroundAsset backgroundInfo = provider.getAsset(AssetTypes.BACKGROUND);
        this.inventoryPoint = backgroundInfo.getInventoryPosition();
        this.xSize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().width;
        this.ySize = provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER).getArea().height;
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AssetUtil.drawAsset(stack, screen, provider.getAsset(AssetTypes.BUTTON_SIDENESS_MANAGER), guiX + this.getPosX(), guiY + this.getPosY());
        int offset = 2;
        GuiComponent.m_93172_((PoseStack)stack, (int)(guiX + this.getPosX() + offset), (int)(guiY + this.getPosY() + offset), (int)(guiX + this.getPosX() + this.getXSize() - offset), (int)(guiY + this.getPosY() + this.getYSize() - offset), (int)this.handler.getColor());
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.isClicked()) {
            screen.m_93228_(stack, guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1, 56, 185, 162, 54);
            screen.m_93228_(stack, guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1 + 54 + 4, 56, 185, 162, 17);
            screen.m_93228_(stack, guiX + backgroundInfo.getInventoryPosition().x - 1, guiY + backgroundInfo.getInventoryPosition().y - 1 + 54 + 4 + 17, 56, 238, 162, 1);
        }
    }

    @Override
    public void drawForegroundLayer(PoseStack stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        if (this.m_5953_(mouseX - guiX, mouseY - guiY)) {
            AssetUtil.drawSelectingOverlay(stack, this.getPosX() + 1, this.getPosY() + 1, this.getPosX() + this.getXSize() - 1, this.getPosY() + this.getYSize() - 1);
        }
        if (this.m_5953_(mouseX - guiX, mouseY - guiY) || this.isClicked()) {
            Object asset = provider.getAsset(this.assetType);
            Rectangle area = this.handler.getRectangle((IAsset)asset);
            AssetUtil.drawHorizontalLine(stack, area.x, area.x + area.width, area.y, this.handler.getColor());
            AssetUtil.drawHorizontalLine(stack, area.x, area.x + area.width, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(stack, area.x, area.y, area.y + area.height, this.handler.getColor());
            AssetUtil.drawVerticalLine(stack, area.x + area.width, area.y, area.y + area.height, this.handler.getColor());
        }
    }

    @Override
    public List<Component> getTooltipLines() {
        return Collections.singletonList(LangUtil.get("tooltip.titanium.facing_handler." + this.handler.getName().toLowerCase(), new Object[0]));
    }

    @Override
    public int getXSize() {
        return this.xSize;
    }

    @Override
    public int getYSize() {
        return this.ySize;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 1) {
            return false;
        }
        final Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof IScreenAddonConsumer && screen instanceof AbstractContainerScreen) {
            if (!this.m_5953_(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                return false;
            }
            IScreenAddonConsumer screenAddonConsumer = (IScreenAddonConsumer)screen;
            final AbstractContainerMenu container = ((MenuAccess)screen).m_6262_();
            Consumer<Boolean> disable = container instanceof IDisableableContainer ? ((IDisableableContainer)container)::setDisabled : value -> {};
            for (GuiEventListener guiEventListener : new ArrayList<IScreenAddon>(((IScreenAddonConsumer)screen).getAddons())) {
                if (!(guiEventListener instanceof FacingHandlerScreenAddon) || guiEventListener == this) continue;
                ((FacingHandlerScreenAddon)guiEventListener).setClicked(screenAddonConsumer, disable, false);
                disable.accept(true);
            }
            this.setClicked(screenAddonConsumer, disable, !this.clicked);
            if (this.clicked) {
                disable.accept(true);
                for (final FacingUtil.Sideness facing : FacingUtil.Sideness.values()) {
                    if (!this.handler.getFacingModes().containsKey((Object)facing)) continue;
                    Point point = FacingHandlerScreenAddon.getPointFromFacing(facing, this.inventoryPoint);
                    ArrayList<StateButtonInfo> stateButtonInfo = new ArrayList<StateButtonInfo>();
                    for (int i = 0; i < this.handler.getValidFacingModes().length; ++i) {
                        stateButtonInfo.add(this.handler.getValidFacingModes()[i].getInfo(i));
                    }
                    StateButtonAddon addon = new StateButtonAddon(new ButtonComponent(point.x, point.y, 14, 14), stateButtonInfo.toArray(new StateButtonInfo[0])){

                        @Override
                        public int getState() {
                            IFacingComponent handler = null;
                            if (container instanceof IObjectContainer) {
                                Object containedObject = ((IObjectContainer)container).getObject();
                                if (containedObject instanceof IFacingComponentHarness) {
                                    handler = ((IFacingComponentHarness)containedObject).getHandlerFromName(FacingHandlerScreenAddon.this.handler.getName());
                                } else {
                                    Titanium.LOGGER.warn("Contained Object is not IFacingComponentHarness. Could not get FacingComponent");
                                }
                            } else {
                                Titanium.LOGGER.warn("Container is not IObjectContainer. Could not get FacingComponent");
                            }
                            return handler != null && handler.getFacingModes().containsKey((Object)facing) ? Arrays.asList(handler.getValidFacingModes()).indexOf((Object)handler.getFacingModes().get((Object)facing)) : 0;
                        }

                        @Override
                        public boolean m_6375_(double mouseX, double mouseY, int mouse) {
                            Screen gui = Minecraft.m_91087_().f_91080_;
                            StateButtonInfo info = this.getStateInfo();
                            if (info != null && gui instanceof MenuAccess) {
                                if (!this.m_5953_(mouseX - (double)((AbstractContainerScreen)screen).getGuiLeft(), mouseY - (double)((AbstractContainerScreen)screen).getGuiTop())) {
                                    return false;
                                }
                                CompoundTag compound = new CompoundTag();
                                compound.m_128359_("Facing", facing.name());
                                int faceMode = (this.getState() + (mouse == 0 ? 1 : -1)) % FacingHandlerScreenAddon.this.handler.getValidFacingModes().length;
                                if (faceMode < 0) {
                                    faceMode = FacingHandlerScreenAddon.this.handler.getValidFacingModes().length - 1;
                                }
                                compound.m_128405_("Next", faceMode);
                                compound.m_128359_("Name", FacingHandlerScreenAddon.this.handler.getName());
                                if (container instanceof ILocatable) {
                                    Titanium.NETWORK.get().sendToServer((Object)new ButtonClickNetworkMessage(((ILocatable)container).getLocatorInstance(), -1, compound));
                                } else {
                                    Titanium.LOGGER.warn("Failed to Find Locatable Instance for Container");
                                }
                                FacingHandlerScreenAddon.this.handler.getFacingModes().put(facing, FacingHandlerScreenAddon.this.handler.getValidFacingModes()[faceMode]);
                            }
                            return true;
                        }

                        @Override
                        public List<Component> getTooltipLines() {
                            ArrayList<Component> strings = new ArrayList<Component>();
                            IFacingComponent.FaceMode mode = FacingHandlerScreenAddon.this.handler.getValidFacingModes()[this.getState()];
                            strings.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString("tooltip.titanium.facing_handler.direction", new Object[0]) + ChatFormatting.RESET + LangUtil.getString("tooltip.titanium.facing_handler." + facing.name().toLowerCase(), new Object[0]) + ChatFormatting.GRAY + " [" + LangUtil.getString("direction.titanium." + FacingUtil.getFacingFromSide(FacingHandlerScreenAddon.this.blockDirection, facing), new Object[0]) + "]")));
                            strings.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + LangUtil.getString("tooltip.titanium.facing_handler.action", new Object[0]) + mode.getColor() + this.getStateInfo().getTooltip()[0].getString())));
                            return strings;
                        }
                    };
                    this.buttonAddons.add(addon);
                    ((IScreenAddonConsumer)screen).getAddons().add(addon);
                }
            }
        }
        return false;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public void setClicked(IScreenAddonConsumer information, Consumer<Boolean> disable, boolean clicked) {
        this.clicked = clicked;
        if (!clicked) {
            information.getAddons().removeIf(iGuiAddon -> this.buttonAddons.contains(iGuiAddon));
            this.buttonAddons.clear();
            disable.accept(false);
        }
    }
}

