/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.net.okhttp;

import cofh.requack.annotation.Requires;
import cofh.requack.net.DownloadAction;
import cofh.requack.net.HttpResponseException;
import cofh.requack.net.download.DownloadListener;
import cofh.requack.net.okhttp.ProgressForwardingSource;
import cofh.requack.util.SneakyUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class OkHttpDownloadAction
implements DownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(OkHttpDownloadAction.class);
    private static final SimpleDateFormat FORMAT_RFC1123 = SneakyUtils.sneaky(() -> {
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format;
    });
    private static final OkHttpClient CLIENT = new OkHttpClient.Builder().build();
    private OkHttpClient client = CLIENT;
    @Nullable
    private String url;
    @Nullable
    private DownloadAction.Dest dest;
    private boolean onlyIfModified;
    private boolean useETag;
    private boolean quiet = true;
    @Nullable
    private String userAgent;
    @Nullable
    private DownloadListener downloadListener;
    private final Map<Class<?>, Object> tags = new HashMap();
    private boolean upToDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        Request.Builder builder = new Request.Builder().url(url);
        if (this.userAgent != null) {
            builder.addHeader("User-Agent", this.userAgent);
        }
        String etag = dest.getEtag();
        if (this.useETag && etag != null) {
            builder.addHeader("If-None-Match", etag.trim());
        }
        long lastModified = dest.getLastModified();
        if (this.onlyIfModified && lastModified != -1L) {
            builder.addHeader("If-Modified-Since", FORMAT_RFC1123.format(new Date(lastModified)));
        }
        for (Map.Entry<Class<?>, Object> entry : this.tags.entrySet()) {
            builder.tag((Class)SneakyUtils.unsafeCast(entry.getKey()), entry.getValue());
        }
        if (this.downloadListener != null) {
            this.downloadListener.connecting();
        }
        if (!this.quiet) {
            LOGGER.info("Connecting to {}.", (Object)url);
        }
        try (Response response = this.client.newCall(builder.build()).execute();){
            boolean timestampNotModified;
            boolean expectNotModified;
            int code = response.code();
            boolean bl = expectNotModified = this.useETag || this.onlyIfModified;
            if (!(code >= 200 && code <= 299 || expectNotModified && code == 304)) {
                throw new HttpResponseException(code, response.message());
            }
            Date lastModifiedHeader = response.headers().getDate("Last-Modified");
            boolean notModified = expectNotModified && code == 304;
            boolean bl2 = timestampNotModified = this.onlyIfModified && lastModifiedHeader != null && lastModified >= lastModifiedHeader.getTime();
            if (notModified || timestampNotModified) {
                if (!this.quiet) {
                    String reason = "";
                    if (code == 304) {
                        reason = reason + "304 not modified ";
                    }
                    if (timestampNotModified) {
                        reason = reason + "Last-Modified header";
                    }
                    LOGGER.info("Not Modified ({}). Skipping '{}'.", (Object)reason.trim(), (Object)url);
                }
                this.upToDate = true;
                return;
            }
            ResponseBody body = response.body();
            if (body == null) {
                return;
            }
            long contentLen = body.contentLength();
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLen);
            }
            Object s = body.source();
            if (this.downloadListener != null) {
                s = new ProgressForwardingSource((Source)s, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (Object source = s;
                 BufferedSink sink = Okio.buffer((Sink)Okio.sink((OutputStream)dest.getOutputStream()));){
                sink.writeAll((Source)source);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeader != null) {
                dest.setLastModified(lastModifiedHeader.getTime());
            }
            String eTagHeader = response.header("ETag");
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader);
            }
        }
    }

    public OkHttpDownloadAction setClient(OkHttpClient client) {
        this.client = client;
        return this;
    }

    @Override
    public OkHttpDownloadAction setUrl(String url) {
        this.url = url;
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(DownloadAction.Dest dest) {
        this.dest = dest;
        return this;
    }

    @Override
    public OkHttpDownloadAction setDest(StringWriter sw) {
        return this.setDest(DownloadAction.Dest.string(sw));
    }

    @Override
    public DownloadAction setDest(OutputStream os) {
        return this.setDest(DownloadAction.Dest.stream(os));
    }

    @Override
    public OkHttpDownloadAction setDest(File file) {
        return this.setDest(DownloadAction.Dest.file(file));
    }

    @Override
    public OkHttpDownloadAction setDest(Path path) {
        return this.setDest(DownloadAction.Dest.path(path));
    }

    @Override
    public OkHttpDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        this.onlyIfModified = onlyIfModified;
        return this;
    }

    @Override
    public OkHttpDownloadAction setUseETag(boolean useETag) {
        this.useETag = useETag;
        return this;
    }

    @Override
    public OkHttpDownloadAction setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    @Override
    public OkHttpDownloadAction setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    @Override
    public OkHttpDownloadAction setDownloadListener(DownloadListener downloadListener) {
        this.downloadListener = downloadListener;
        return this;
    }

    public OkHttpDownloadAction addTag(Class<?> clazz, Object tag) {
        this.tags.put(clazz, tag);
        return this;
    }

    @Override
    public boolean isUpToDate() {
        return this.upToDate;
    }

    public OkHttpClient getClient() {
        return this.client;
    }

    @Override
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public DownloadAction.Dest getDest() {
        return this.dest;
    }

    @Override
    public boolean getOnlyIfModified() {
        return this.onlyIfModified;
    }

    @Override
    public boolean getUseETag() {
        return this.useETag;
    }

    @Override
    public boolean getQuiet() {
        return this.quiet;
    }

    @Override
    @Nullable
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @Nullable
    public DownloadListener getDownloadListener() {
        return this.downloadListener;
    }

    public Map<Class<?>, Object> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }
}

