/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IItemStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementItemStackRender;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import mcjty.theoneprobe.network.NetworkTools;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ElementItemStack
implements IElement {
    private final ItemStack itemStack;
    private final IItemStyle style;

    public ElementItemStack(ItemStack itemStack, IItemStyle style) {
        this.itemStack = itemStack;
        this.style = style;
    }

    public ElementItemStack(FriendlyByteBuf buf) {
        this.itemStack = buf.readBoolean() ? NetworkTools.readItemStack(buf) : ItemStack.f_41583_;
        this.style = new ItemStyle().width(buf.readInt()).height(buf.readInt());
    }

    @Override
    public void render(PoseStack matrixStack, int x, int y) {
        ElementItemStackRender.render(this.itemStack, this.style, matrixStack, x, y);
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        if (!this.itemStack.m_41619_()) {
            buf.writeBoolean(true);
            NetworkTools.writeItemStack(buf, this.itemStack);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_ITEM;
    }
}

