/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import com.mojang.blaze3d.vertex.PoseStack;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IIconStyle;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementIconRender;
import mcjty.theoneprobe.apiimpl.styles.IconStyle;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ElementIcon
implements IElement {
    private final ResourceLocation icon;
    private final int u;
    private final int v;
    private final int w;
    private final int h;
    private final IIconStyle style;

    public ElementIcon(ResourceLocation icon, int u, int v, int w, int h, IIconStyle style) {
        this.icon = icon;
        this.u = u;
        this.v = v;
        this.w = w;
        this.h = h;
        this.style = style;
    }

    public ElementIcon(FriendlyByteBuf buf) {
        this.icon = buf.m_130281_();
        this.u = buf.readInt();
        this.v = buf.readInt();
        this.w = buf.readInt();
        this.h = buf.readInt();
        this.style = new IconStyle().width(buf.readInt()).height(buf.readInt()).textureWidth(buf.readInt()).textureHeight(buf.readInt()).color(buf.readInt());
    }

    public IIconStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(PoseStack matrixStack, int x, int y) {
        ElementIconRender.render(this.icon, matrixStack, x, y, this.w, this.h, this.u, this.v, this.style.getTextureWidth(), this.style.getTextureHeight(), this.style.getColor());
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.icon);
        buf.writeInt(this.u);
        buf.writeInt(this.v);
        buf.writeInt(this.w);
        buf.writeInt(this.h);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.writeInt(this.style.getTextureWidth());
        buf.writeInt(this.style.getTextureHeight());
        buf.writeInt(this.style.getColor());
    }

    @Override
    public ResourceLocation getID() {
        return TheOneProbeImp.ELEMENT_ICON;
    }
}

