/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.Objects;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.elements.ElementProgress;
import mcjty.theoneprobe.rendering.RenderHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

public class ElementProgressRender {
    private static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");

    public static void render(IProgressStyle style, long current, long max, PoseStack matrixStack, int x, int y, int w, int h) {
        if (style.isLifeBar()) {
            ElementProgressRender.renderLifeBar(current, matrixStack, x, y, w, h);
        } else if (style.isArmorBar()) {
            ElementProgressRender.renderArmorBar(current, matrixStack, x, y, w, h);
        } else {
            RenderHelper.drawThickBeveledBox(matrixStack, x, y, x + w, y + h, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
            if (current > 0L && max > 0L) {
                int dx = (int)Math.min(current * (long)(w - 2) / max, (long)(w - 2));
                if (style.getFilledColor() == style.getAlternatefilledColor()) {
                    if (dx > 0) {
                        RenderHelper.drawThickBeveledBox(matrixStack, x + 1, y + 1, x + dx + 1, y + h - 1, 1, style.getFilledColor(), style.getFilledColor(), style.getFilledColor());
                    }
                } else {
                    for (int xx = x + 1; xx < x + dx + 1; ++xx) {
                        int color = (xx & 1) == 0 ? style.getFilledColor() : style.getAlternatefilledColor();
                        RenderHelper.drawVerticalLine(matrixStack, xx, y + 1, y + h - 1, color);
                    }
                }
            }
        }
        ElementProgressRender.renderText(matrixStack, x, y, w, current, style);
    }

    private static void renderText(PoseStack matrixStack, int x, int y, int w, long current, IProgressStyle style) {
        if (style.isShowText()) {
            Minecraft mc = Minecraft.m_91087_();
            Font render = mc.f_91062_;
            MutableComponent s = style.getPrefixComp().m_6881_().m_7220_(ElementProgress.format(current, style.getNumberFormat(), style.getSuffixComp()));
            int textWidth = render.m_92724_(s.m_7532_());
            switch (style.getAlignment()) {
                case ALIGN_BOTTOMRIGHT: {
                    RenderHelper.renderText(mc, matrixStack, x + w - 3 - textWidth, y + 2, (Component)s);
                    break;
                }
                case ALIGN_CENTER: {
                    RenderHelper.renderText(mc, matrixStack, x + w / 2 - textWidth / 2, y + 2, (Component)s);
                    break;
                }
                case ALIGN_TOPLEFT: {
                    RenderHelper.renderText(mc, matrixStack, x + 3, y + 2, (Component)s);
                }
            }
        }
    }

    private static void renderLifeBar(long current, PoseStack matrixStack, int x, int y, int w, int h) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (current * 4L >= (long)w) {
            RenderHelper.drawTexturedModalRect(matrix, x, y, 52, 0, 9, 9);
            RenderHelper.renderText(Minecraft.m_91087_(), matrixStack, x + 12, y, ChatFormatting.WHITE + String.valueOf(current / 2L));
        } else {
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 52, 0, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 61, 0, 9, 9);
            }
        }
    }

    private static void renderArmorBar(long current, PoseStack matrixStack, int x, int y, int w, int h) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICONS);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        if (current * 4L >= (long)w) {
            RenderHelper.drawTexturedModalRect(matrix, x, y, 43, 9, 9, 9);
            RenderHelper.renderText(Minecraft.m_91087_(), matrixStack, x + 12, y, ChatFormatting.WHITE + String.valueOf(current / 2L));
        } else {
            int i = 0;
            while ((long)i < current / 2L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 43, 9, 9, 9);
                x += 8;
                ++i;
            }
            if (current % 2L != 0L) {
                RenderHelper.drawTexturedModalRect(matrix, x, y, 25, 9, 9, 9);
            }
        }
    }

    public static void renderTank(PoseStack matrixStack, int x, int y, int width, int height, IProgressStyle style, TankReference tank) {
        RenderHelper.drawThickBeveledBox(matrixStack, x, y, x + width, y + height, 1, style.getBorderColor(), style.getBorderColor(), style.getBackgroundColor());
        if (tank.getStored() <= 0) {
            if (style.isShowText()) {
                ElementProgressRender.renderText(matrixStack, x, y, width, 0L, style);
            }
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Function map = mc.m_91258_(InventoryMenu.f_39692_);
        width -= 2;
        FluidStack[] fluids = tank.getFluids();
        int start = 1;
        int tanks = fluids.length;
        int max = tank.getCapacity();
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        for (FluidStack stack : fluids) {
            ResourceLocation stillTexture;
            TextureAtlasSprite liquidIcon;
            int lvl = (int)(stack == null ? 0.0 : (double)stack.getAmount() / (double)max * (double)width);
            if (lvl <= 0 || Objects.equals(liquidIcon = (TextureAtlasSprite)map.apply(stillTexture = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getStillTexture(stack)), map.apply(MissingTextureAtlasSprite.m_118071_()))) continue;
            int color = IClientFluidTypeExtensions.of((Fluid)stack.getFluid()).getTintColor(stack);
            RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >> 24 & 0xFF) / 255.0f));
            while (lvl > 0) {
                int maxX = Math.min(16, lvl);
                lvl -= maxX;
                RenderHelper.drawTexturedModalRect(matrix, x + start, y + 1, liquidIcon, maxX, height - 2);
                start += maxX;
            }
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (style.isShowText()) {
            ElementProgressRender.renderText(matrixStack, x, y, width + 2, tank.getStored(), style);
        }
    }
}

