/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;

@ParametersAreNonnullByDefault
public class HoloFilterButton
extends GuiElement {
    private final List<Component> tooltip;
    private final GuiString label;
    private final Consumer<String> onChange;
    private final GuiTexture icon;
    private boolean inputFocused = false;
    private String filter = "";

    public HoloFilterButton(int x, int y, Consumer<String> onChange) {
        super(x, y, 11, 9);
        this.onChange = onChange;
        this.icon = new GuiTexture(0, 0, 9, 9, 206, 0, GuiTextures.workbench);
        this.icon.setColor(0x7F7F7F);
        this.addChild((GuiElement)this.icon);
        this.label = new GuiString(11, 0, "");
        this.addChild((GuiElement)this.label);
        this.tooltip = Collections.singletonList(Component.m_237115_((String)"tetra.holo.craft.variants_filter"));
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (this.hasFocus()) {
            this.setInputFocused(true);
            return true;
        }
        return false;
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return null;
    }

    private void setInputFocused(boolean focused) {
        this.inputFocused = focused;
        if (this.inputFocused) {
            this.icon.setColor(0xFFFFCC);
        } else if (this.filter.length() > 0) {
            this.icon.setColor(0xFFFFFF);
        } else {
            this.icon.setColor(0x7F7F7F);
        }
    }

    public boolean onKeyPress(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 259: {
                if (Screen.m_96637_()) {
                    this.updateFilter("");
                }
                if (this.filter.length() > 0) {
                    this.updateFilter(StringUtils.chop((String)this.filter));
                }
                return true;
            }
            case 257: {
                this.setInputFocused(!this.inputFocused);
                return true;
            }
            case 256: {
                if (!this.inputFocused) break;
                this.setInputFocused(false);
                return true;
            }
        }
        return false;
    }

    public boolean onCharType(char character, int modifiers) {
        if (this.inputFocused) {
            this.filter = this.filter + character;
            this.updateFilter((String)this.filter);
            return true;
        }
        if (character == 'f') {
            this.setInputFocused(true);
            return true;
        }
        return false;
    }

    public void updateFilter(String newValue) {
        this.filter = newValue;
        this.label.setString(this.filter);
        this.onChange.accept(this.filter);
        this.setWidth(11 + this.label.getWidth());
    }

    public void reset() {
        this.filter = "";
        this.label.setString(this.filter);
        this.setWidth(11);
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        if (this.inputFocused && System.currentTimeMillis() % 800L < 400L) {
            HoloFilterButton.drawRect((PoseStack)matrixStack, (int)(refX + this.x + 12 + this.label.getWidth()), (int)(refY + this.y + 7), (int)(refX + this.x + 17 + this.label.getWidth()), (int)(refY + this.y + 8), (int)0xFFFFFF, (float)1.0f);
        }
    }
}

