/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.capabilities;

import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractReference;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CombinedFluidHandler
implements IFluidHandler {
    private final Channel channel;
    private final TesseractBlockEntity requester;

    public CombinedFluidHandler(Channel channel, TesseractBlockEntity requester) {
        this.channel = channel;
        this.requester = requester;
    }

    public int getTanks() {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int tanks = 0;
        for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        this.popRecurrentCall();
        return tanks;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        if (this.pushRecurrentCall()) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = FluidStack.EMPTY;
        int tanks = 0;
        block0: for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    stack = handler.getFluidInTank(tank - tanks);
                    break block0;
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        this.popRecurrentCall();
        return stack;
    }

    public int getTankCapacity(int tank) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        int capacity = 0;
        int tanks = 0;
        block0: for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    capacity = handler.getTankCapacity(tank - tanks);
                    break block0;
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        this.popRecurrentCall();
        return capacity;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        if (this.pushRecurrentCall()) {
            return false;
        }
        boolean valid = false;
        int tanks = 0;
        block0: for (TesseractReference location : this.channel.tesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (tank - tanks < handler.getTanks()) {
                    valid = handler.isFluidValid(tank - tanks, stack);
                    break block0;
                }
                tanks += Math.max(handler.getTanks(), 0);
            }
        }
        this.popRecurrentCall();
        return valid;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.pushRecurrentCall()) {
            return 0;
        }
        if (!this.requester.canSend(EnumChannelType.FLUID) || resource.isEmpty()) {
            this.popRecurrentCall();
            return 0;
        }
        FluidStack fluid = resource.copy();
        int amount = 0;
        block0: for (TesseractReference location : this.channel.receivingTesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if ((amount += handler.fill(fluid, action)) >= resource.getAmount()) break block0;
                fluid.setAmount(resource.getAmount() - amount);
            }
        }
        this.popRecurrentCall();
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.pushRecurrentCall()) {
            return FluidStack.EMPTY;
        }
        if (!this.requester.canReceive(EnumChannelType.FLUID) || resource == null || resource.isEmpty()) {
            this.popRecurrentCall();
            return FluidStack.EMPTY;
        }
        FluidStack fluid = resource.copy();
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                FluidStack stack = handler.drain(fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
                if (!stack.isEmpty() && resource.isFluidEqual(stack)) {
                    if (action.execute()) {
                        handler.drain(fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    fluid.setAmount(fluid.getAmount() - stack.getAmount());
                }
                if (!fluid.isEmpty()) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        if (fluid.getAmount() == resource.getAmount()) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(resource.getAmount() - fluid.getAmount());
        return fluid;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.pushRecurrentCall()) {
            return FluidStack.EMPTY;
        }
        if (!this.requester.canReceive(EnumChannelType.FLUID) || maxDrain <= 0) {
            this.popRecurrentCall();
            return FluidStack.EMPTY;
        }
        FluidStack fluid = null;
        block0: for (TesseractReference location : this.channel.sendingTesseracts) {
            TesseractBlockEntity entity;
            if (!location.canBeAccessed() || (entity = location.getTesseract()) == this.requester) continue;
            for (IFluidHandler handler : entity.getSurroundingCapabilities(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
                if (fluid == null) {
                    fluid = handler.drain(maxDrain, action);
                    if (fluid.isEmpty()) {
                        fluid = null;
                        continue;
                    }
                    fluid.setAmount(maxDrain - fluid.getAmount());
                    continue;
                }
                FluidStack stack = handler.drain(fluid.copy(), IFluidHandler.FluidAction.SIMULATE);
                if (!stack.isEmpty() && fluid.isFluidEqual(stack)) {
                    if (action.execute()) {
                        handler.drain(fluid.copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    fluid.setAmount(fluid.getAmount() - stack.getAmount());
                }
                if (!fluid.isEmpty()) continue;
                break block0;
            }
        }
        this.popRecurrentCall();
        if (fluid == null) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(maxDrain - fluid.getAmount());
        return fluid;
    }

    private boolean pushRecurrentCall() {
        if (this.requester.recurrentCalls >= 1) {
            return true;
        }
        ++this.requester.recurrentCalls;
        return false;
    }

    private void popRecurrentCall() {
        --this.requester.recurrentCalls;
    }
}

