/*
 * Decompiled with CFR 0.152.
 */
package chiefarug.mods.systeams.block_entities;

import chiefarug.mods.systeams.block_entities.BoilerBlockEntityBase;
import cofh.lib.api.StorageGroup;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.lib.util.managers.SingleItemFuelManager;
import cofh.thermal.lib.util.recipes.IThermalInventory;
import cofh.thermal.lib.util.recipes.internal.IDynamoFuel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemBoilerBlockEntityBase
extends BoilerBlockEntityBase {
    protected ItemStorageCoFH fuelSlot = new ItemStorageCoFH(item -> this.filter.valid(item) && this.getFuelManager().validFuel(item));

    public ItemBoilerBlockEntityBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.inventory.addSlot(this.fuelSlot, StorageGroup.INPUT);
        this.addAugmentSlots(ThermalCoreConfig.dynamoAugments);
    }

    protected abstract SingleItemFuelManager getFuelManager();

    @Override
    protected int getFuelEnergy() {
        IDynamoFuel fuel = this.getFuelManager().getFuel((IThermalInventory)this);
        return fuel == null ? 0 : fuel.getEnergy();
    }

    @Override
    protected int consumeFuel() {
        int energy = this.getFuelEnergy();
        this.fuelSlot.consume(1);
        return energy;
    }
}

