/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.mob_container;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.supplementaries.api.CapturedMobInstance;
import net.mehvahdjukaar.supplementaries.api.ICatchableMob;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.BuiltinAnimation;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.DataCapturedMobInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public final class DataDefinedCatchableMob
implements ICatchableMob {
    public static final Codec<DataDefinedCatchableMob> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("owners").forGetter(p -> p.owners), (App)Codec.FLOAT.fieldOf("width_increment").forGetter(p -> Float.valueOf(p.widthIncrement)), (App)Codec.FLOAT.fieldOf("height_increment").forGetter(p -> Float.valueOf(p.heightIncrement)), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.lightLevel), (App)CaptureSettings.CODEC.optionalFieldOf("allowed_in").forGetter(p -> p.captureSettings), (App)Codec.INT.optionalFieldOf("fish_index", (Object)0).forGetter(p -> p.fishIndex), (App)BuiltinAnimation.Type.CODEC.optionalFieldOf("animation", (Object)BuiltinAnimation.Type.NONE).forGetter(b -> b.builtinAnimation), (App)TickMode.CODEC.optionalFieldOf("tick_mode", (Object)TickMode.NONE).forGetter(p -> p.tickMode), (App)ResourceLocation.f_135803_.optionalFieldOf("force_fluid").forGetter(p -> p.forceFluidID), (App)LootParam.CODEC.optionalFieldOf("loot").forGetter(p -> p.loot)).apply((Applicative)instance, DataDefinedCatchableMob::new));
    private final List<ResourceLocation> owners;
    final float widthIncrement;
    final float heightIncrement;
    final int lightLevel;
    final Optional<CaptureSettings> captureSettings;
    final int fishIndex;
    final BuiltinAnimation.Type builtinAnimation;
    final TickMode tickMode;
    final Optional<ResourceLocation> forceFluidID;
    final Optional<LootParam> loot;
    private Optional<SoftFluid> forceFluid = null;

    public DataDefinedCatchableMob(List<ResourceLocation> owners, float widthIncrement, float heightIncrement, int lightLevel, Optional<CaptureSettings> captureSettings, int fishIndex, BuiltinAnimation.Type builtinAnimation, TickMode tickMode, Optional<ResourceLocation> forceFluidID, Optional<LootParam> loot) {
        this.widthIncrement = widthIncrement;
        this.heightIncrement = heightIncrement;
        this.lightLevel = lightLevel;
        this.captureSettings = captureSettings;
        this.fishIndex = fishIndex;
        this.builtinAnimation = builtinAnimation;
        this.forceFluidID = forceFluidID;
        this.loot = loot;
        this.tickMode = tickMode;
        this.owners = owners;
    }

    List<ResourceLocation> getOwners() {
        return this.owners;
    }

    @Override
    public <T extends Entity> CapturedMobInstance<T> createCapturedMobInstance(T self, float containerWidth, float containerHeight) {
        return new DataCapturedMobInstance<T>(self, containerWidth, containerHeight, this);
    }

    @Override
    public boolean canBeCaughtWithItem(Entity entity, Item item, Player player) {
        return this.captureSettings.map(settings -> settings.canCapture(entity, item)).orElseGet(() -> ICatchableMob.super.canBeCaughtWithItem(entity, item, player));
    }

    @Override
    public int getLightLevel(Level world, BlockPos pos) {
        return this.lightLevel;
    }

    @Override
    public boolean shouldHover(Entity self, boolean waterlogged) {
        BuiltinAnimation.Type cat = this.builtinAnimation;
        if (cat.isLand()) {
            return false;
        }
        return cat.isFlying() || ICatchableMob.super.shouldHover(self, waterlogged);
    }

    @Override
    public Optional<SoftFluid> shouldRenderWithFluid() {
        if (this.forceFluid == null) {
            this.forceFluid = this.forceFluidID.flatMap(SoftFluidRegistry::getOptional);
        }
        return this.forceFluid;
    }

    @Override
    public int getFishTextureIndex() {
        return this.fishIndex;
    }

    @Override
    public float getHitBoxWidthIncrement(Entity entity) {
        return this.widthIncrement;
    }

    @Override
    public float getHitBoxHeightIncrement(Entity entity) {
        return this.heightIncrement;
    }

    static enum TickMode implements StringRepresentable
    {
        NONE,
        SERVER,
        CLIENT,
        BOTH;

        public static final Codec<TickMode> CODEC;

        boolean isValid(Level level) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case NONE -> false;
                case CLIENT -> level.f_46443_;
                case SERVER -> {
                    if (!level.f_46443_) {
                        yield true;
                    }
                    yield false;
                }
                case BOTH -> true;
            };
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(TickMode::values);
        }
    }

    protected record CaptureSettings(CatchMode jarMode, CatchMode cageMode) {
        private static final Codec<CaptureSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CatchMode.CODEC.fieldOf("jar").forGetter(CaptureSettings::jarMode), (App)CatchMode.CODEC.fieldOf("cage").forGetter(CaptureSettings::cageMode)).apply((Applicative)instance, CaptureSettings::new));

        public boolean canCapture(Entity entity, Item item) {
            LivingEntity le;
            if (item instanceof JarItem) {
                LivingEntity le2;
                return this.jarMode.on && (!this.jarMode.onlyBaby || !(entity instanceof LivingEntity) || (le2 = (LivingEntity)entity).m_6162_());
            }
            return this.cageMode.on && (!this.cageMode.onlyBaby || !(entity instanceof LivingEntity) || (le = (LivingEntity)entity).m_6162_());
        }
    }

    protected record LootParam(ResourceLocation tableId, float chance) {
        private static final Codec<LootParam> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("loot_table").forGetter(LootParam::tableId), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance").forGetter(LootParam::chance)).apply((Applicative)instance, LootParam::new));

        public void tryDropping(ServerLevel serverLevel, BlockPos pos, Entity entity) {
            if (serverLevel.f_46441_.m_188501_() < this.chance) {
                LootTable lootTable = serverLevel.m_7654_().m_129898_().m_79217_(this.tableId);
                LootContext.Builder builder = new LootContext.Builder(serverLevel).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81461_, (Object)serverLevel.m_8055_(pos)).m_78984_(LootContextParams.f_81455_, (Object)entity);
                ObjectArrayList l = lootTable.m_230922_(builder.m_78975_(LootContextParamSets.f_81416_));
                for (ItemStack o : l) {
                    entity.m_19983_(o);
                }
            }
        }
    }

    protected record CatchMode(boolean on, boolean onlyBaby) {
        private static final Codec<CatchMode> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("allow").forGetter(CatchMode::on), (App)Codec.BOOL.optionalFieldOf("only_baby", (Object)false).forGetter(CatchMode::onlyBaby)).apply((Applicative)instance, CatchMode::new));
    }
}

