/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.optifine;

import com.ldtteam.structurize.api.util.Log;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Matrix4f;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;

public class OptifineCompat {
    private static final String DISABLE_REASON = "waiting for optifine to catch up with vanilla";
    private static OptifineCompat ourInstance = new OptifineCompat();
    private Method isFogOffMethod;
    private Method setFogAllowedMethod;
    private Method isShadersEnabledMethod;
    private Method calcNormalForLayerMethod;
    private Method setupArrayPointersVboMethod;
    private Method preRenderChunkLayerMethod;
    private Method setModelViewMatrixMethod;
    private Method setProjectionMatrixMethod;
    private Method setTextureMatrixMethod;
    private Method setColorModulatorMethod;
    private TriFloatReflectionConsumer setUniformChunkOffsetValueMethod;
    private Method postRenderChunkLayerMethod;
    private Method endTerrainMethod;
    private Method beginEntitiesMethod;
    private Method nextEntityMethod;
    private Method endEntitiesMethod;
    private Method beginBlockEntitiesMethod;
    private Method nextBlockEntityMethod;
    private Method endBlockEntitiesMethod;
    private Method flushRenderBuffersMethod;
    private Method beginDebug;
    private Method endDebug;
    private Method preWaterMethod;
    private Method beginWaterMethod;
    private Method endWaterMethod;
    private boolean currentShadowPassFieldValue = false;
    private Field isShadowPassField;
    private boolean currentIsRenderingWorldFieldValue = false;
    private Field isRenderingWorldField;
    private Field fogStandardField;
    private Field activeProgramIdField;
    private boolean enableOptifine = false;

    public static OptifineCompat getInstance() {
        return ourInstance;
    }

    private OptifineCompat() {
    }

    public boolean isOptifineEnabled() {
        return this.enableOptifine;
    }

    public void intialize() {
        if (DISABLE_REASON != null && !DISABLE_REASON.isBlank()) {
            Log.getLogger().info("Optifine compat disabled. Reason: waiting for optifine to catch up with vanilla");
            return;
        }
        try {
            this.setupReflectedMethodReferences();
            Log.getLogger().info("Optifine found. Enabling compat.");
            this.enableOptifine = true;
        }
        catch (ClassNotFoundException e) {
            Log.getLogger().info("Optifine not found. Disabling compat.");
            this.enableOptifine = false;
        }
        catch (NoSuchMethodException e) {
            Log.getLogger().error("Optifine found. But could not access related methods.", (Throwable)e);
            this.enableOptifine = false;
        }
        catch (NoSuchFieldException e) {
            Log.getLogger().error("Optifine found. But could not access related fields", (Throwable)e);
            this.enableOptifine = false;
        }
    }

    private void setupReflectedMethodReferences() throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        Class<?> configClass = Class.forName("net.optifine.Config");
        Class<?> shaderRenderClass = Class.forName("net.optifine.shaders.ShadersRender");
        Class<?> sVertexBuilderClass = Class.forName("net.optifine.shaders.SVertexBuilder");
        Class<?> shadersClass = Class.forName("net.optifine.shaders.Shaders");
        Class<?> shaderUniform3fClass = Class.forName("net.optifine.shaders.uniform.ShaderUniform3f");
        Class<RenderSystem> renderSystemClass = RenderSystem.class;
        Class<FogRenderer> fogRendererClass = FogRenderer.class;
        Class<MultiBufferSource> multiBufferSourceClass = MultiBufferSource.class;
        this.isFogOffMethod = configClass.getMethod("isFogOff", new Class[0]);
        this.isFogOffMethod.setAccessible(true);
        this.fogStandardField = fogRendererClass.getField("fogStandard");
        this.fogStandardField.setAccessible(true);
        this.setFogAllowedMethod = renderSystemClass.getMethod("setFogAllowed", Boolean.TYPE);
        this.setFogAllowedMethod.setAccessible(true);
        this.isShadersEnabledMethod = configClass.getMethod("isShaders", new Class[0]);
        this.isShadersEnabledMethod.setAccessible(true);
        this.isShadowPassField = shadersClass.getField("isShadowPass");
        this.isShadowPassField.setAccessible(true);
        this.isRenderingWorldField = shadersClass.getField("isRenderingWorld");
        this.isRenderingWorldField.setAccessible(true);
        this.calcNormalForLayerMethod = sVertexBuilderClass.getMethod("calcNormalChunkLayer", BufferBuilder.class);
        this.calcNormalForLayerMethod.setAccessible(true);
        this.preRenderChunkLayerMethod = shaderRenderClass.getMethod("preRenderChunkLayer", RenderType.class);
        this.preRenderChunkLayerMethod.setAccessible(true);
        this.setModelViewMatrixMethod = shadersClass.getMethod("setModelViewMatrix", Matrix4f.class);
        this.setModelViewMatrixMethod.setAccessible(true);
        this.setProjectionMatrixMethod = shadersClass.getMethod("setProjectionMatrix", Matrix4f.class);
        this.setProjectionMatrixMethod.setAccessible(true);
        this.setTextureMatrixMethod = shadersClass.getMethod("setTextureMatrix", Matrix4f.class);
        this.setTextureMatrixMethod.setAccessible(true);
        this.setColorModulatorMethod = shadersClass.getMethod("setColorModulator", float[].class);
        this.setColorModulatorMethod.setAccessible(true);
        this.activeProgramIdField = shadersClass.getField("activeProgramID");
        this.activeProgramIdField.setAccessible(true);
        Field uniformChunkOffsetField = shadersClass.getField("uniform_chunkOffset");
        uniformChunkOffsetField.setAccessible(true);
        Method setValueMethod = shaderUniform3fClass.getMethod("setValue", Float.TYPE, Float.TYPE, Float.TYPE);
        setValueMethod.setAccessible(true);
        this.setUniformChunkOffsetValueMethod = (x, y, z) -> setValueMethod.invoke(uniformChunkOffsetField.get(null), Float.valueOf(x), Float.valueOf(y), Float.valueOf(z));
        this.setupArrayPointersVboMethod = shaderRenderClass.getMethod("setupArrayPointersVbo", new Class[0]);
        this.setupArrayPointersVboMethod.setAccessible(true);
        this.postRenderChunkLayerMethod = shaderRenderClass.getMethod("postRenderChunkLayer", RenderType.class);
        this.postRenderChunkLayerMethod.setAccessible(true);
        this.endTerrainMethod = shaderRenderClass.getMethod("endTerrain", new Class[0]);
        this.endTerrainMethod.setAccessible(true);
        this.beginEntitiesMethod = shadersClass.getMethod("beginEntities", new Class[0]);
        this.beginEntitiesMethod.setAccessible(true);
        this.nextEntityMethod = shadersClass.getMethod("nextEntity", Entity.class);
        this.nextEntityMethod.setAccessible(true);
        this.endEntitiesMethod = shadersClass.getMethod("endEntities", new Class[0]);
        this.endEntitiesMethod.setAccessible(true);
        this.beginBlockEntitiesMethod = shadersClass.getMethod("beginBlockEntities", new Class[0]);
        this.beginBlockEntitiesMethod.setAccessible(true);
        this.nextBlockEntityMethod = shadersClass.getMethod("nextBlockEntity", BlockEntity.class);
        this.nextBlockEntityMethod.setAccessible(true);
        this.endBlockEntitiesMethod = shadersClass.getMethod("endBlockEntities", new Class[0]);
        this.endBlockEntitiesMethod.setAccessible(true);
        this.flushRenderBuffersMethod = multiBufferSourceClass.getMethod("flushRenderBuffers", new Class[0]);
        this.flushRenderBuffersMethod.setAccessible(true);
        this.beginDebug = shaderRenderClass.getMethod("beginDebug", new Class[0]);
        this.beginDebug.setAccessible(true);
        this.endDebug = shaderRenderClass.getMethod("endDebug", new Class[0]);
        this.endDebug.setAccessible(true);
        this.preWaterMethod = shadersClass.getMethod("preWater", new Class[0]);
        this.preWaterMethod.setAccessible(true);
        this.beginWaterMethod = shadersClass.getMethod("beginWater", new Class[0]);
        this.beginWaterMethod.setAccessible(true);
        this.endWaterMethod = shadersClass.getMethod("endWater", new Class[0]);
        this.endWaterMethod.setAccessible(true);
    }

    public void setupFog() {
        this.tryRun(() -> {
            if (((Boolean)this.isFogOffMethod.invoke(null, new Object[0])).booleanValue() && this.fogStandardField.getBoolean(null)) {
                this.setFogAllowedMethod.invoke(null, Boolean.FALSE);
            }
        });
    }

    public void resetFog() {
        this.tryRun(() -> this.setFogAllowedMethod.invoke(null, Boolean.TRUE));
    }

    public void beforeBuilderUpload(BufferBuilder bufferBuilder) {
        this.tryRun(() -> this.calcNormalForLayerMethod.invoke(null, bufferBuilder));
    }

    public void preBlueprintDraw() {
        this.tryRunIfShadersEnabled(() -> {
            this.currentShadowPassFieldValue = this.isShadowPassField.getBoolean(null);
            this.isShadowPassField.set(null, false);
            this.currentIsRenderingWorldFieldValue = this.isRenderingWorldField.getBoolean(null);
            this.isRenderingWorldField.set(null, true);
        });
    }

    public void preLayerDraw(RenderType layer, Matrix4f mvMatrix) {
        this.tryRunIfShadersEnabled(() -> {
            this.preRenderChunkLayerMethod.invoke(null, layer);
            this.setModelViewMatrixMethod.invoke(null, mvMatrix);
            this.setProjectionMatrixMethod.invoke(null, RenderSystem.m_157192_());
            this.setTextureMatrixMethod.invoke(null, RenderSystem.m_157207_());
            this.setColorModulatorMethod.invoke(null, new Object[]{RenderSystem.m_157197_()});
        });
    }

    public boolean isShaderProgramActive() {
        return this.trySupplyIfShadersEnabled(() -> this.activeProgramIdField.getInt(null) > 0, false);
    }

    public void setUniformChunkOffset(float x, float y, float z) {
        this.tryRunIfShadersEnabled(() -> this.setUniformChunkOffsetValueMethod.invoke(x, y, z));
    }

    public void setupArrayPointers() {
        this.tryRunIfShadersEnabled(() -> this.setupArrayPointersVboMethod.invoke(null, new Object[0]));
    }

    public void postLayerDraw(RenderType layer) {
        this.tryRunIfShadersEnabled(() -> this.postRenderChunkLayerMethod.invoke(null, layer));
    }

    public void endTerrainBeginEntities() {
        this.tryRunIfShadersEnabled(() -> {
            this.endTerrainMethod.invoke(null, new Object[0]);
            this.beginEntitiesMethod.invoke(null, new Object[0]);
        });
    }

    public void preRenderEntity(Entity entity) {
        this.tryRunIfShadersEnabled(() -> this.nextEntityMethod.invoke(null, entity));
    }

    public void endEntitiesBeginBlockEntities() {
        this.tryRunIfShadersEnabled(() -> {
            this.endEntitiesMethod.invoke(null, new Object[0]);
            this.beginBlockEntitiesMethod.invoke(null, new Object[0]);
        });
    }

    public void preRenderBlockEntity(BlockEntity blockEntity) {
        this.tryRunIfShadersEnabled(() -> this.nextBlockEntityMethod.invoke(null, blockEntity));
    }

    public void endBlockEntitiesBeginDebug(RenderBuffers renderBuffers) {
        this.tryRunIfShadersEnabled(() -> this.endBlockEntitiesMethod.invoke(null, new Object[0]));
        this.tryRun(() -> {
            this.flushRenderBuffersMethod.invoke((Object)renderBuffers.m_110104_(), new Object[0]);
            this.flushRenderBuffersMethod.invoke((Object)renderBuffers.m_110108_(), new Object[0]);
        });
        this.tryRunIfShadersEnabled(() -> this.beginDebug.invoke(null, new Object[0]));
    }

    public void endDebugPreWaterBeginWater() {
        this.tryRunIfShadersEnabled(() -> {
            this.endDebug.invoke(null, new Object[0]);
            this.preWaterMethod.invoke(null, new Object[0]);
            this.beginWaterMethod.invoke(null, new Object[0]);
        });
    }

    public void endWater() {
        this.tryRunIfShadersEnabled(() -> this.endWaterMethod.invoke(null, new Object[0]));
    }

    public void postBlueprintDraw() {
        this.tryRunIfShadersEnabled(() -> {
            this.isShadowPassField.set(null, this.currentShadowPassFieldValue);
            this.isRenderingWorldField.set(null, this.currentIsRenderingWorldFieldValue);
        });
    }

    private void tryRunIfShadersEnabled(ReflectionRunnable code) {
        this.tryRun(() -> {
            if (((Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0])).booleanValue()) {
                code.run();
            }
        });
    }

    private void tryRun(ReflectionRunnable code) {
        if (!this.enableOptifine) {
            return;
        }
        try {
            code.run();
        }
        catch (ReflectiveOperationException e) {
            Log.getLogger().error("Failed to access Optifine related rendering things.", (Throwable)e);
            Log.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
        }
    }

    private <T> T trySupplyIfShadersEnabled(ReflectionSupplier<T> code, T defaultValue) {
        return (T)this.trySupply(() -> (Boolean)this.isShadersEnabledMethod.invoke(null, new Object[0]) != false ? code.get() : defaultValue, defaultValue);
    }

    private <T> T trySupply(ReflectionSupplier<T> code, T defaultValue) {
        if (!this.enableOptifine) {
            return defaultValue;
        }
        try {
            return code.get();
        }
        catch (ReflectiveOperationException e) {
            Log.getLogger().error("Failed to access Optifine related rendering things.", (Throwable)e);
            Log.getLogger().error("Disabling Optifine Compat.");
            this.enableOptifine = false;
            return defaultValue;
        }
    }

    @FunctionalInterface
    private static interface TriFloatReflectionConsumer {
        public void invoke(float var1, float var2, float var3) throws ReflectiveOperationException;
    }

    @FunctionalInterface
    private static interface ReflectionRunnable {
        public void run() throws ReflectiveOperationException;
    }

    @FunctionalInterface
    private static interface ReflectionSupplier<T> {
        public T get() throws ReflectiveOperationException;
    }
}

